/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlId;
import is.codion.swing.common.ui.control.ControlSet;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DefaultControlSet
implements ControlSet {
    private final Map<ControlId<?>, Value<Control>> controls;

    DefaultControlSet(Class<?> controlIdsClass) {
        this(Stream.of(controlIdsClass.getFields()).filter(DefaultControlSet::publicStaticFinalControlId).map(DefaultControlSet::controlId).collect(Collectors.toList()));
    }

    private DefaultControlSet(Collection<ControlId<?>> controlIds) {
        this.controls = Collections.unmodifiableMap(controlIds.stream().collect(Collectors.toMap(Function.identity(), controlId -> Value.nullable().build())));
    }

    @Override
    public <T extends Control> Value<T> control(ControlId<T> controlId) {
        Value<Control> value = this.controls.get(Objects.requireNonNull(controlId));
        if (value == null) {
            throw new IllegalArgumentException("Unknown controlId");
        }
        return value;
    }

    @Override
    public Collection<Value<Control>> controls() {
        return this.controls.values();
    }

    static boolean publicStaticFinalControlId(Field field) {
        return Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && ControlId.class.isAssignableFrom(field.getType());
    }

    static ControlId<?> controlId(Field field) {
        try {
            return (ControlId)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

