/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.control.ControlId;
import is.codion.swing.common.ui.control.ControlKeyStrokes;
import is.codion.swing.common.ui.control.DefaultControlSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.KeyStroke;

final class DefaultControlKeyStrokes
implements ControlKeyStrokes {
    private final Map<ControlId<?>, Value<KeyStroke>> keyStrokes = new HashMap();

    DefaultControlKeyStrokes(Class<?> controlIdsClass) {
        this(Stream.of(controlIdsClass.getFields()).filter(DefaultControlSet::publicStaticFinalControlId).map(DefaultControlSet::controlId).collect(Collectors.toList()));
    }

    DefaultControlKeyStrokes(Collection<ControlId<?>> controlIds) {
        controlIds.forEach(controlId -> this.keyStrokes.put((ControlId<?>)controlId, (Value<KeyStroke>)Value.nullable().initialValue((Object)controlId.defaultKeystroke().orElse(null)).build()));
    }

    private DefaultControlKeyStrokes(DefaultControlKeyStrokes controlKeyStrokes) {
        controlKeyStrokes.keyStrokes.forEach((controlType, keyStrokeValue) -> this.keyStrokes.put((ControlId<?>)controlType, (Value<KeyStroke>)Value.nullable().initialValue((Object)((KeyStroke)keyStrokeValue.get())).build()));
    }

    @Override
    public Value<KeyStroke> keyStroke(ControlId<?> controlId) {
        Value<KeyStroke> keyStroke = this.keyStrokes.get(controlId);
        if (keyStroke == null) {
            throw new IllegalArgumentException("Unknown controlId");
        }
        return keyStroke;
    }

    @Override
    public ControlKeyStrokes copy() {
        return new DefaultControlKeyStrokes(this);
    }
}

