/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.resource.MessageBundle;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.component.text.DefaultParseResult;
import is.codion.swing.common.ui.component.text.Parser;
import is.codion.swing.common.ui.component.text.ValidationDocumentFilter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

class NumberDocument<T extends Number>
extends PlainDocument {
    NumberDocument(NumberFormat format, Class<T> clazz) {
        this(new NumberParsingDocumentFilter<T>(new NumberParser<T>(format, clazz)));
    }

    protected NumberDocument(NumberParsingDocumentFilter<T> documentFilter) {
        super.setDocumentFilter(documentFilter);
    }

    @Override
    public final void setDocumentFilter(DocumentFilter filter) {
        throw new UnsupportedOperationException("Changing the DocumentFilter of NumberDocument and its descendants is not allowed");
    }

    @Override
    public final NumberParsingDocumentFilter<T> getDocumentFilter() {
        return (NumberParsingDocumentFilter)super.getDocumentFilter();
    }

    protected final NumberFormat getFormat() {
        return ((NumberParser)((NumberParsingDocumentFilter)this.getDocumentFilter()).parser()).getFormat();
    }

    protected final void setNumber(T number) {
        this.setText(number == null ? "" : this.getFormat().format(number));
    }

    protected final T getNumber() {
        try {
            return (T)((Number)((NumberParsingDocumentFilter)this.getDocumentFilter()).parser().parse(this.getText(0, this.getLength())).value());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void setText(String text) {
        try {
            if (!Objects.equals(this.getText(0, this.getLength()), text)) {
                this.remove(0, this.getLength());
                this.insertString(0, text, null);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    final ValueObserver<T> numberValue() {
        return ((NumberParsingDocumentFilter)this.getDocumentFilter()).value.observer();
    }

    void setTextComponent(JTextComponent textComponent) {
        ((NumberParsingDocumentFilter)this.getDocumentFilter()).setTextComponent(textComponent);
    }

    void setGroupingUsed(boolean groupingUsed) {
        T number = this.getNumber();
        this.getFormat().setGroupingUsed(groupingUsed);
        this.setNumber(number);
    }

    void setSeparators(char decimalSeparator, char groupingSeparator) {
        if (decimalSeparator == groupingSeparator) {
            throw new IllegalArgumentException("Decimal separator must not be the same as grouping separator");
        }
        DecimalFormatSymbols symbols = ((DecimalFormat)this.getFormat()).getDecimalFormatSymbols();
        symbols.setDecimalSeparator(decimalSeparator);
        symbols.setGroupingSeparator(groupingSeparator);
        T number = this.getNumber();
        ((DecimalFormat)this.getFormat()).setDecimalFormatSymbols(symbols);
        this.setNumber(number);
    }

    void setDecimalSeparator(char decimalSeparator) {
        DecimalFormatSymbols symbols = ((DecimalFormat)this.getFormat()).getDecimalFormatSymbols();
        if (decimalSeparator == symbols.getGroupingSeparator()) {
            symbols.setGroupingSeparator(symbols.getDecimalSeparator());
        }
        symbols.setDecimalSeparator(decimalSeparator);
        T number = this.getNumber();
        ((DecimalFormat)this.getFormat()).setDecimalFormatSymbols(symbols);
        this.setNumber(number);
    }

    void setGroupingSeparator(char groupingSeparator) {
        DecimalFormatSymbols symbols = ((DecimalFormat)this.getFormat()).getDecimalFormatSymbols();
        if (groupingSeparator == symbols.getDecimalSeparator()) {
            symbols.setDecimalSeparator(symbols.getGroupingSeparator());
        }
        symbols.setGroupingSeparator(groupingSeparator);
        T number = this.getNumber();
        ((DecimalFormat)this.getFormat()).setDecimalFormatSymbols(symbols);
        this.setNumber(number);
    }

    static final class NumberParsingDocumentFilter<T extends Number>
    extends ValidationDocumentFilter<T> {
        private static final MessageBundle MESSAGES = MessageBundle.messageBundle(NumberParsingDocumentFilter.class, (ResourceBundle)ResourceBundle.getBundle(NumberParsingDocumentFilter.class.getName()));
        private final NumberRangeValidator<T> rangeValidator;
        private final NumberParser<T> parser;
        private final Value<T> value = Value.value();
        private JTextComponent textComponent;
        private boolean convertGroupingToDecimalSeparator = true;
        private boolean rethrowValidationException = true;

        NumberParsingDocumentFilter(NumberParser<T> parser) {
            this.parser = Objects.requireNonNull(parser, "parser");
            this.rangeValidator = new NumberRangeValidator();
            this.addValidator(this.rangeValidator);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String string, AttributeSet attributeSet) throws BadLocationException {
            this.replace(filterBypass, offset, 0, string, attributeSet);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int offset, int length) throws BadLocationException {
            this.replace(filterBypass, offset, length, "", null);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String text, AttributeSet attributeSet) throws BadLocationException {
            if (text != null) {
                text = this.convertSingleGroupingToDecimalSeparator(text);
                Document document = filterBypass.getDocument();
                StringBuilder builder = new StringBuilder(document.getText(0, document.getLength()));
                builder.replace(offset, offset + length, text);
                Parser.ParseResult parseResult = this.parser.parse(builder.toString());
                if (parseResult.successful()) {
                    this.validateReplace((NumberParser.NumberParseResult<T>)parseResult, filterBypass, attributeSet, offset + text.length() + parseResult.charetOffset());
                }
            }
        }

        Parser<T> parser() {
            return this.parser;
        }

        void setMaximumValue(Number maximumValue) {
            this.rangeValidator.maximumValue = maximumValue;
        }

        Number getMaximumValue() {
            return this.rangeValidator.maximumValue;
        }

        void setMinimumValue(Number minimumValue) {
            this.rangeValidator.minimumValue = minimumValue;
        }

        Number getMinimumValue() {
            return this.rangeValidator.minimumValue;
        }

        void setConvertGroupingToDecimalSeparator(boolean convertGroupingToDecimalSeparator) {
            this.convertGroupingToDecimalSeparator = convertGroupingToDecimalSeparator;
        }

        boolean isConvertGroupingToDecimalSeparator() {
            return this.convertGroupingToDecimalSeparator;
        }

        void setRethrowValidationException(boolean rethrowValidationException) {
            this.rethrowValidationException = rethrowValidationException;
        }

        boolean isRethrowValidationException() {
            return this.rethrowValidationException;
        }

        void setTextComponent(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        private String convertSingleGroupingToDecimalSeparator(String text) {
            if (this.convertGroupingToDecimalSeparator && text.length() == 1 && this.parser.format instanceof DecimalFormat) {
                DecimalFormatSymbols formatSymbols = ((DecimalFormat)this.parser.format).getDecimalFormatSymbols();
                return text.replace(formatSymbols.getGroupingSeparator(), formatSymbols.getDecimalSeparator());
            }
            return text;
        }

        private void validateReplace(NumberParser.NumberParseResult<T> parseResult, DocumentFilter.FilterBypass filterBypass, AttributeSet attributeSet, int dotLocation) throws BadLocationException {
            if (parseResult.value() != null) {
                try {
                    this.validate((Number)parseResult.value());
                }
                catch (IllegalArgumentException e) {
                    if (this.rethrowValidationException) {
                        throw e;
                    }
                    return;
                }
            }
            super.replace(filterBypass, 0, filterBypass.getDocument().getLength(), parseResult.text(), attributeSet);
            this.value.set((Object)((Number)parseResult.value()));
            if (this.textComponent != null) {
                this.textComponent.getCaret().setDot(dotLocation);
            }
        }

        private static final class NumberRangeValidator<T extends Number>
        implements Value.Validator<T> {
            private Number minimumValue;
            private Number maximumValue;

            private NumberRangeValidator() {
            }

            public void validate(T value) {
                if (!this.withinRange(value)) {
                    throw new IllegalArgumentException(MESSAGES.getString("value_outside_range") + ": " + this.minimumValue + " - " + this.maximumValue);
                }
            }

            private boolean withinRange(T value) {
                return value == null || this.greaterThanMinimum(value) && this.lessThanMaximum(value);
            }

            private boolean greaterThanMinimum(T value) {
                return this.minimumValue == null || ((Number)value).doubleValue() >= this.minimumValue.doubleValue();
            }

            private boolean lessThanMaximum(T value) {
                return this.maximumValue == null || ((Number)value).doubleValue() <= this.maximumValue.doubleValue();
            }
        }
    }

    static class NumberParser<T extends Number>
    implements Parser<T> {
        private static final String MINUS_SIGN = "-";
        private final NumberFormat format;
        private final Class<T> clazz;

        protected NumberParser(NumberFormat format, Class<T> clazz) {
            this.format = Objects.requireNonNull(format, "format");
            this.format.setRoundingMode(RoundingMode.DOWN);
            this.clazz = Objects.requireNonNull(clazz, "clazz");
        }

        @Override
        public NumberParseResult<T> parse(String string) {
            if (string.isEmpty() || MINUS_SIGN.equals(string)) {
                return new DefaultNumberParseResult<Object>(string, null);
            }
            T parsedNumber = this.parseNumber(string);
            if (parsedNumber != null) {
                Object formattedNumber = this.format.format(parsedNumber);
                if (this.format instanceof DecimalFormat) {
                    int decimalSeparatorIndex;
                    String decimalSeparator = String.valueOf(((DecimalFormat)this.format).getDecimalFormatSymbols().getDecimalSeparator());
                    if (!((String)formattedNumber).contains(decimalSeparator) && string.endsWith(decimalSeparator)) {
                        formattedNumber = (String)formattedNumber + decimalSeparator;
                    }
                    if ((decimalSeparatorIndex = string.indexOf(decimalSeparator)) >= 0 && string.substring(decimalSeparatorIndex).endsWith("0")) {
                        formattedNumber = (String)formattedNumber + (((String)formattedNumber).contains(decimalSeparator) ? "" : decimalSeparator) + NumberParser.trailingDecimalZeros(string, decimalSeparatorIndex);
                    }
                }
                return new DefaultNumberParseResult<T>((String)formattedNumber, parsedNumber, this.countAddedGroupingSeparators(string, (String)formattedNumber), true);
            }
            return new DefaultNumberParseResult<Object>(string, null, 0, false);
        }

        protected final NumberFormat getFormat() {
            return this.format;
        }

        private T parseNumber(String text) {
            if (text.isEmpty()) {
                return null;
            }
            ParsePosition position = new ParsePosition(0);
            Number number = this.format.parse(text, position);
            if (position.getIndex() != text.length() || position.getErrorIndex() != -1) {
                return null;
            }
            return (T)this.toType(number);
        }

        private T toType(T number) {
            if (this.clazz.equals(Short.class)) {
                return this.toShort(number);
            }
            if (this.clazz.equals(Integer.class)) {
                return this.toInteger(number);
            }
            if (this.clazz.equals(Long.class)) {
                return this.toLong(number);
            }
            if (this.clazz.equals(Double.class)) {
                return this.toDouble(number);
            }
            if (this.clazz.equals(BigDecimal.class)) {
                return this.toBigDecimal(number);
            }
            throw new IllegalArgumentException("Unsupported type class: " + this.clazz);
        }

        private T toShort(T number) {
            if (number instanceof Short) {
                return number;
            }
            return (T)Short.valueOf(((Number)number).shortValue());
        }

        private T toInteger(T number) {
            if (number instanceof Integer) {
                return number;
            }
            return (T)Integer.valueOf(((Number)number).intValue());
        }

        private T toLong(T number) {
            if (number instanceof Long) {
                return number;
            }
            return (T)Long.valueOf(((Number)number).longValue());
        }

        private T toDouble(T number) {
            if (number instanceof Double) {
                return number;
            }
            return (T)Double.valueOf(((Number)number).doubleValue());
        }

        private T toBigDecimal(T number) {
            if (number instanceof BigDecimal) {
                return number;
            }
            return (T)BigDecimal.valueOf(((Number)number).doubleValue());
        }

        private int countAddedGroupingSeparators(String currentNumber, String newNumber) {
            DecimalFormatSymbols symbols = ((DecimalFormat)this.format).getDecimalFormatSymbols();
            return NumberParser.count(newNumber, symbols.getGroupingSeparator()) - NumberParser.count(currentNumber, symbols.getGroupingSeparator());
        }

        private static String trailingDecimalZeros(String string, int decimalSeparatorIndex) {
            StringBuilder builder = new StringBuilder();
            int index = string.length() - 1;
            char c = string.charAt(index);
            while (c == '0' && index > decimalSeparatorIndex) {
                builder.append('0');
                c = string.charAt(--index);
            }
            return builder.toString();
        }

        private static int count(String string, char groupingSeparator) {
            int counter = 0;
            for (char c : string.toCharArray()) {
                if (c != groupingSeparator) continue;
                ++counter;
            }
            return counter;
        }

        protected static final class DefaultNumberParseResult<T extends Number>
        extends DefaultParseResult<T>
        implements NumberParseResult<T> {
            private final int charetOffset;

            private DefaultNumberParseResult(String text, T value) {
                this(text, value, 0, true);
            }

            DefaultNumberParseResult(String text, T value, int charetOffset, boolean successful) {
                super(text, value, successful);
                this.charetOffset = charetOffset;
            }

            @Override
            public int charetOffset() {
                return this.charetOffset;
            }
        }

        protected static interface NumberParseResult<T extends Number>
        extends Parser.ParseResult<T> {
            public int charetOffset();
        }
    }

    static final class DecimalDocument<T extends Number>
    extends NumberDocument<T> {
        static final int MAXIMUM_FRACTION_DIGITS = 340;

        DecimalDocument(DecimalFormat format, boolean parseBigDecimal) {
            super(new NumberParsingDocumentFilter(new DecimalDocumentParser(format, parseBigDecimal)));
            if (parseBigDecimal) {
                format.setParseBigDecimal(true);
            }
        }

        int getMaximumFractionDigits() {
            int maximumFractionDigits = this.getFormat().getMaximumFractionDigits();
            return maximumFractionDigits == 340 ? -1 : maximumFractionDigits;
        }

        void setMaximumFractionDigits(int maximumFractionDigits) {
            if (maximumFractionDigits < -1) {
                throw new IllegalArgumentException("Maximum fraction digits must be => 0, or -1 for no maximum");
            }
            this.getFormat().setMaximumFractionDigits(maximumFractionDigits == -1 ? 340 : maximumFractionDigits);
            this.setText("");
        }

        private static final class DecimalDocumentParser<T extends Number>
        extends NumberParser<T> {
            private DecimalDocumentParser(DecimalFormat format, boolean parseBigDecimal) {
                super(format, parseBigDecimal ? BigDecimal.class : Double.class);
            }

            @Override
            public NumberParser.NumberParseResult<T> parse(String string) {
                char decimalSeparator = ((DecimalFormat)this.getFormat()).getDecimalFormatSymbols().getDecimalSeparator();
                if (string.equals(Character.toString(decimalSeparator))) {
                    try {
                        return new NumberParser.DefaultNumberParseResult<Number>("0" + decimalSeparator, this.getFormat().parse("0"), 1, true);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                return super.parse(string);
            }
        }
    }
}

