/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.model.table.TableConditionModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.FilterTableColumnComponentPanel;
import is.codion.swing.common.ui.component.table.FilterTableColumnModel;
import is.codion.swing.common.ui.component.table.TableConditionPanel;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class FilterTableConditionPanel<C>
extends TableConditionPanel<C> {
    private final Collection<ColumnConditionPanel<C, ?>> conditionPanels;
    private final FilterTableColumnModel<C> columnModel;
    private final Event<?> initializedEvent = Event.event();
    private FilterTableColumnComponentPanel<C> componentPanel;
    private boolean initialized;

    private FilterTableConditionPanel(TableConditionModel<C> conditionModel, Collection<ColumnConditionPanel<C, ?>> conditionPanels, FilterTableColumnModel<C> columnModel) {
        super(conditionModel);
        this.conditionPanels = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(conditionPanels)));
        this.columnModel = Objects.requireNonNull(columnModel);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI(this.componentPanel);
    }

    @Override
    public Collection<ColumnConditionPanel<C, ?>> conditionPanels() {
        return this.conditionPanels;
    }

    @Override
    public Collection<ColumnConditionPanel<C, ?>> selectableConditionPanels() {
        return this.conditionPanels.stream().filter(conditionPanel -> (Boolean)this.columnModel.visible(conditionPanel.conditionModel().columnIdentifier()).get()).collect(Collectors.toList());
    }

    @Override
    public Optional<EventObserver<?>> initializedEvent() {
        return Optional.of(this.initializedEvent.observer());
    }

    public static <C> FilterTableConditionPanel<C> filterTableConditionPanel(TableConditionModel<C> conditionModel, Collection<ColumnConditionPanel<C, ?>> conditionPanels, FilterTableColumnModel<C> columnModel) {
        return new FilterTableConditionPanel<C>(conditionModel, conditionPanels, columnModel);
    }

    @Override
    protected void onStateChanged(ColumnConditionPanel.ConditionState conditionState) {
        this.conditionPanels.forEach(panel -> panel.state().set((Object)conditionState));
        switch (conditionState) {
            case HIDDEN: {
                this.remove(this.componentPanel);
                break;
            }
            case SIMPLE: 
            case ADVANCED: {
                this.initialize();
                this.add(this.componentPanel, "Center");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown panel state: " + conditionState);
            }
        }
        this.revalidate();
    }

    private void initialize() {
        if (!this.initialized) {
            this.setLayout(new BorderLayout());
            Map conditionPanelMap = this.conditionPanels.stream().collect(Collectors.toMap(panel -> panel.conditionModel().columnIdentifier(), Function.identity()));
            this.componentPanel = FilterTableColumnComponentPanel.filterTableColumnComponentPanel(this.columnModel, conditionPanelMap);
            this.initialized = true;
            this.initializedEvent.run();
        }
    }
}

