/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.Configuration;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.property.PropertyValue;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.Colors;
import is.codion.swing.common.ui.component.table.DefaultFilterTableCellRendererBuilder;
import java.awt.Color;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;

public interface FilterTableCellRenderer
extends TableCellRenderer {
    public static final PropertyValue<Integer> TABLE_CELL_LEFT_PADDING = Configuration.integerValue((String)(FilterTableCellRenderer.class.getName() + ".cellLeftPadding"), (int)0);
    public static final PropertyValue<Integer> TABLE_CELL_RIGHT_PADDING = Configuration.integerValue((String)(FilterTableCellRenderer.class.getName() + ".cellRightPadding"), (int)5);
    public static final PropertyValue<Integer> NUMERICAL_HORIZONTAL_ALIGNMENT = Configuration.integerValue((String)(FilterTableCellRenderer.class.getName() + ".numericalHorizontalAlignment"), (int)4);
    public static final PropertyValue<Integer> TEMPORAL_HORIZONTAL_ALIGNMENT = Configuration.integerValue((String)(FilterTableCellRenderer.class.getName() + ".temporalHorizontalAlignment"), (int)4);
    public static final PropertyValue<Integer> BOOLEAN_HORIZONTAL_ALIGNMENT = Configuration.integerValue((String)(FilterTableCellRenderer.class.getName() + ".booleanHorizontalAlignment"), (int)0);
    public static final PropertyValue<Integer> HORIZONTAL_ALIGNMENT = Configuration.integerValue((String)(FilterTableCellRenderer.class.getName() + ".horizontalAlignment"), (int)10);
    public static final PropertyValue<Boolean> ALTERNATE_ROW_COLORING = Configuration.booleanValue((String)(FilterTableCellRenderer.class.getName() + ".alternateRowColoring"), (boolean)true);

    public boolean columnShading();

    public boolean alternateRowColoring();

    public int horizontalAlignment();

    public static <R, C> Builder<R, C> builder(FilterTableModel<R, C> tableModel, C columnIdentifier, Class<?> columnClass) {
        return new DefaultFilterTableCellRendererBuilder<R, C>(tableModel, columnIdentifier, columnClass);
    }

    public static class Settings<C> {
        protected static final float SELECTION_COLOR_BLEND_RATIO = 0.5f;
        protected static final double DARKENING_FACTOR = 0.9;
        protected static final double DOUBLE_DARKENING_FACTOR = 0.8;
        protected static final int FOCUSED_CELL_BORDER_THICKNESS = 1;
        private final int leftPadding;
        private final int rightPadding;
        private final boolean alternateRowColoring;
        private Color foregroundColor;
        private Color backgroundColor;
        private Color backgroundColorShaded;
        private Color backgroundColorAlternate;
        private Color backgroundColorAlternateShaded;
        private Color selectionBackground;
        private Color selectionBackgroundAlternate;
        private Border defaultCellBorder;
        private Border focusedCellBorder;

        protected Settings(int leftPadding, int rightPadding, boolean alternateRowColoring) {
            this.leftPadding = leftPadding;
            this.rightPadding = rightPadding;
            this.alternateRowColoring = alternateRowColoring;
        }

        final Color foregroundColor(Color cellForegroundColor) {
            return cellForegroundColor == null ? this.foregroundColor : cellForegroundColor;
        }

        final Border focusedCellBorder() {
            return this.focusedCellBorder;
        }

        final Border defaultCellBorder() {
            return this.defaultCellBorder;
        }

        protected void updateColors() {
            this.foregroundColor = UIManager.getColor("Table.foreground");
            this.backgroundColor = UIManager.getColor("Table.background");
            this.backgroundColorAlternate = UIManager.getColor("Table.alternateRowColor");
            if (this.backgroundColorAlternate == null) {
                this.backgroundColorAlternate = Colors.darker(this.backgroundColor, 0.8);
            }
            this.selectionBackground = UIManager.getColor("Table.selectionBackground");
            this.backgroundColorShaded = Colors.darker(this.backgroundColor, 0.9);
            this.backgroundColorAlternateShaded = Colors.darker(this.backgroundColorAlternate, 0.9);
            this.selectionBackgroundAlternate = Colors.darker(this.selectionBackground, 0.9);
            this.defaultCellBorder = this.leftPadding > 0 || this.rightPadding > 0 ? BorderFactory.createEmptyBorder(0, this.leftPadding, 0, this.rightPadding) : null;
            this.focusedCellBorder = Settings.createFocusedCellBorder(this.foregroundColor, this.defaultCellBorder);
        }

        protected final Color backgroundColor(FilterTableModel<?, C> tableModel, int row, C columnIdentifier, boolean columnShading, boolean selected, Color cellBackgroundColor) {
            cellBackgroundColor = this.backgroundColor(cellBackgroundColor, row, selected);
            if (columnShading) {
                cellBackgroundColor = this.backgroundColorShaded(tableModel, row, columnIdentifier, cellBackgroundColor);
            }
            if (cellBackgroundColor != null) {
                return cellBackgroundColor;
            }
            return this.alternateRowColor(row) ? this.backgroundColor : this.backgroundColorAlternate;
        }

        protected Color backgroundColorShaded(FilterTableModel<?, C> tableModel, int row, C columnIdentifier, Color cellBackgroundColor) {
            boolean filterEnabled;
            ColumnConditionModel filterModel = (ColumnConditionModel)tableModel.filterModel().conditionModels().get(columnIdentifier);
            boolean bl = filterEnabled = filterModel != null && (Boolean)filterModel.enabled().get() != false;
            if (filterEnabled) {
                return this.backgroundShaded(row, cellBackgroundColor);
            }
            return cellBackgroundColor;
        }

        protected final Color backgroundColor() {
            return this.backgroundColor;
        }

        protected final Color backgroundColorShaded() {
            return this.backgroundColorShaded;
        }

        protected final Color backgroundColorAlternate() {
            return this.backgroundColorAlternate;
        }

        protected final Color backgroundColorAlternateShaded() {
            return this.backgroundColorAlternateShaded;
        }

        private Color backgroundColor(Color cellBackgroundColor, int row, boolean selected) {
            if (selected) {
                if (cellBackgroundColor == null) {
                    return this.selectionBackgroundColor(row);
                }
                return Settings.blendColors(cellBackgroundColor, this.selectionBackgroundColor(row));
            }
            return cellBackgroundColor;
        }

        private Color selectionBackgroundColor(int row) {
            return this.alternateRowColor(row) ? this.selectionBackground : this.selectionBackgroundAlternate;
        }

        private Color backgroundShaded(int row, Color cellBackgroundColor) {
            if (cellBackgroundColor != null) {
                return Colors.darker(cellBackgroundColor, 0.9);
            }
            return this.alternateRowColor(row) ? this.backgroundColorShaded : this.backgroundColorAlternateShaded;
        }

        protected boolean alternateRowColor(int row) {
            return this.alternateRowColoring && row % 2 == 0;
        }

        private static CompoundBorder createFocusedCellBorder(Color foregroundColor, Border defaultCellBorder) {
            return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Colors.darker(foregroundColor, 0.8), 1), defaultCellBorder);
        }

        private static Color blendColors(Color color1, Color color2) {
            int r = (int)((float)color1.getRed() * 0.5f) + (int)((float)color2.getRed() * 0.5f);
            int g = (int)((float)color1.getGreen() * 0.5f) + (int)((float)color2.getGreen() * 0.5f);
            int b = (int)((float)color1.getBlue() * 0.5f) + (int)((float)color2.getBlue() * 0.5f);
            return new Color(r, g, b, color1.getAlpha());
        }
    }

    public static interface Builder<R, C> {
        public Builder<R, C> horizontalAlignment(int var1);

        public Builder<R, C> toolTipData(boolean var1);

        public Builder<R, C> columnShading(boolean var1);

        public Builder<R, C> alternateRowColoring(boolean var1);

        public Builder<R, C> leftPadding(int var1);

        public Builder<R, C> rightPadding(int var1);

        public Builder<R, C> string(Function<Object, String> var1);

        public Builder<R, C> cellColors(CellColors<C> var1);

        public FilterTableCellRenderer build();
    }

    public static interface CellColors<C> {
        default public Color backgroundColor(int row, C columnIdentifier, Object cellValue, boolean selected) {
            return null;
        }

        default public Color foregroundColor(int row, C columnIdentifier, Object cellValue, boolean selected) {
            return null;
        }
    }
}

