/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.event.EventObserver;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class ColumnConditionPanel<C, T>
extends JPanel {
    private final ColumnConditionModel<C, T> conditionModel;
    private final Value<ConditionState> conditionState = Value.nonNull((Object)((Object)ConditionState.HIDDEN)).consumer(this::onStateChanged).build();
    private final State hiddenState = State.state((boolean)true);
    private final State simpleState = State.state();
    private final State advancedState = State.state();
    private final String caption;

    protected ColumnConditionPanel(ColumnConditionModel<C, T> conditionModel) {
        this(Objects.requireNonNull(conditionModel), conditionModel.columnIdentifier().toString());
        this.configureStates();
    }

    protected ColumnConditionPanel(ColumnConditionModel<C, T> conditionModel, String caption) {
        this.conditionModel = Objects.requireNonNull(conditionModel);
        this.caption = Objects.requireNonNull(caption);
    }

    public final ColumnConditionModel<C, T> conditionModel() {
        return this.conditionModel;
    }

    public final Value<ConditionState> state() {
        return this.conditionState;
    }

    public final String caption() {
        return this.caption;
    }

    public abstract Collection<JComponent> components();

    public abstract void requestInputFocus();

    public Optional<EventObserver<C>> focusGainedEvent() {
        return Optional.empty();
    }

    protected abstract void onStateChanged(ConditionState var1);

    private void configureStates() {
        State.group((State[])new State[]{this.hiddenState, this.simpleState, this.advancedState});
        this.hiddenState.addConsumer((Consumer)new StateConsumer(ConditionState.HIDDEN));
        this.simpleState.addConsumer((Consumer)new StateConsumer(ConditionState.SIMPLE));
        this.advancedState.addConsumer((Consumer)new StateConsumer(ConditionState.ADVANCED));
        this.conditionState.addConsumer(state -> {
            this.hiddenState.set((Object)(state == ConditionState.HIDDEN ? 1 : 0));
            this.simpleState.set((Object)(state == ConditionState.SIMPLE ? 1 : 0));
            this.advancedState.set((Object)(state == ConditionState.ADVANCED ? 1 : 0));
        });
    }

    public static enum ConditionState {
        HIDDEN,
        SIMPLE,
        ADVANCED;

    }

    private final class StateConsumer
    implements Consumer<Boolean> {
        private final ConditionState state;

        private StateConsumer(ConditionState state) {
            this.state = state;
        }

        @Override
        public void accept(Boolean enabled) {
            if (enabled.booleanValue()) {
                ColumnConditionPanel.this.conditionState.set((Object)this.state);
            }
        }
    }
}

