/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.combobox;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.swing.common.ui.component.combobox.CompletionDocument;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public final class Completion {
    public static final PropertyValue<Mode> COMBO_BOX_COMPLETION_MODE = Configuration.enumValue((String)(Completion.class.getName() + ".completionMode"), Mode.class, (Enum)Mode.MAXIMUM_MATCH);

    public static <C extends JComboBox<T>, T> C maximumMatch(C comboBox) {
        return Completion.maximumMatch(comboBox, Normalize.YES);
    }

    public static <C extends JComboBox<T>, T> C maximumMatch(C comboBox, Normalize normalize) {
        new MaximumMatchDocument(comboBox, normalize);
        return comboBox;
    }

    public static <C extends JComboBox<T>, T> C autoComplete(C comboBox) {
        return Completion.autoComplete(comboBox, Normalize.YES);
    }

    public static <C extends JComboBox<T>, T> C autoComplete(C comboBox, Normalize normalize) {
        new AutoCompletionDocument(comboBox, normalize);
        return comboBox;
    }

    public static <C extends JComboBox<T>, T> C enable(C comboBox) {
        return Completion.enable(comboBox, (Mode)((Object)COMBO_BOX_COMPLETION_MODE.get()));
    }

    public static <C extends JComboBox<T>, T> C enable(C comboBox, Mode completionMode) {
        Objects.requireNonNull(comboBox);
        Objects.requireNonNull(completionMode);
        switch (completionMode) {
            case NONE: {
                break;
            }
            case AUTOCOMPLETE: {
                Completion.autoComplete(comboBox);
                break;
            }
            case MAXIMUM_MATCH: {
                Completion.maximumMatch(comboBox);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown completion mode: " + completionMode);
            }
        }
        comboBox.addFocusListener(new CompletionFocusListener((JTextComponent)comboBox.getEditor().getEditorComponent()));
        return comboBox;
    }

    public static enum Normalize {
        YES,
        NO;

    }

    private static final class MaximumMatchDocument
    extends CompletionDocument {
        private MaximumMatchDocument(JComboBox<?> comboBox, Normalize normalize) {
            super(comboBox, normalize == Normalize.YES);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            int offs = offset;
            if (this.selecting() || this.comboBoxModel().getSize() == 0) {
                return;
            }
            super.insertString(offs, str, a);
            boolean match = false;
            Object item = this.lookupItem(this.getText(0, this.getLength()));
            if (item != null) {
                match = true;
                this.setSelectedItem(item);
            } else {
                item = this.comboBox().getSelectedItem();
                offs -= str.length();
            }
            offs = match ? this.maximumMatchingOffset(this.getText(0, this.getLength()), item) : (offs += str.length());
            this.setTextAccordingToSelectedItem();
            this.highlightCompletedText(offs);
        }

        private int maximumMatchingOffset(String pattern, Object selectedItem) {
            String selectedAsString = selectedItem.toString();
            int match = selectedAsString.length();
            for (int i = 0; i < this.comboBoxModel().getSize(); ++i) {
                int tmpMatch;
                String itemAsString;
                Object currentItem = this.comboBoxModel().getElementAt(i);
                String string = itemAsString = currentItem == null ? "" : currentItem.toString();
                if (!MaximumMatchDocument.startsWithIgnoreCase(itemAsString, pattern, this.normalize()) || (tmpMatch = this.equalStartLength(itemAsString, selectedAsString)) >= match) continue;
                match = tmpMatch;
            }
            return match;
        }

        private int equalStartLength(String str1, String str2) {
            String one = this.normalize() ? MaximumMatchDocument.normalize(str1) : str1;
            String two = this.normalize() ? MaximumMatchDocument.normalize(str2) : str2;
            char[] ch1 = one.toUpperCase().toCharArray();
            char[] ch2 = two.toUpperCase().toCharArray();
            int n = Math.min(ch1.length, ch2.length);
            for (int i = 0; i < n; ++i) {
                if (ch1[i] == ch2[i]) continue;
                return i;
            }
            return n;
        }
    }

    private static final class AutoCompletionDocument
    extends CompletionDocument {
        private AutoCompletionDocument(JComboBox<?> comboBox, Normalize normalize) {
            super(comboBox, normalize == Normalize.YES);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            int offs = offset;
            if (this.selecting()) {
                return;
            }
            super.insertString(offs, str, a);
            Object item = this.lookupItem(this.getText(0, this.getLength()));
            if (item != null) {
                this.setSelectedItem(item);
            } else {
                offs -= str.length();
            }
            this.setTextAccordingToSelectedItem();
            this.highlightCompletedText(offs + str.length());
        }
    }

    public static enum Mode {
        MAXIMUM_MATCH,
        AUTOCOMPLETE,
        NONE;

    }

    private static final class CompletionFocusListener
    implements FocusListener {
        private final JTextComponent editor;

        private CompletionFocusListener(JTextComponent editor) {
            this.editor = editor;
        }

        @Override
        public void focusGained(FocusEvent e) {
            int length = this.editor.getText().length();
            if (length > 0) {
                this.editor.setCaretPosition(length);
                this.editor.moveCaretPosition(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.editor.select(0, 0);
        }
    }
}

