/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui;

import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public final class Windows {
    private Windows() {
    }

    public static Dimension screenSizeRatio(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException("Ratio must be between 0 and 1");
        }
        Dimension screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
        return new Dimension((int)(screen.getWidth() * ratio), (int)(screen.getHeight() * ratio));
    }

    public static void setSizeWithinScreenBounds(Window window) {
        Dimension screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().getSize();
        Dimension frameSize = window.getSize();
        if (frameSize.getHeight() > screenSize.getHeight() || frameSize.getWidth() > screenSize.getWidth()) {
            Dimension newFrameSize = new Dimension((int)Math.min(frameSize.getWidth(), screenSize.getWidth()), (int)Math.min(frameSize.getHeight(), screenSize.getHeight()));
            window.setSize(newFrameSize);
        }
    }

    public static void resizeWindow(Window window, double screenSizeRatio) {
        Windows.resizeWindow(window, screenSizeRatio, null, null);
    }

    public static void resizeWindow(Window window, double screenSizeRatio, Dimension minimumSize, Dimension maximumSize) {
        Dimension ratioSize = Windows.screenSizeRatio(screenSizeRatio);
        if (minimumSize != null) {
            ratioSize.setSize(Math.max(minimumSize.width, ratioSize.width), Math.max(minimumSize.height, ratioSize.height));
        }
        if (maximumSize != null) {
            ratioSize.setSize(Math.min(maximumSize.width, ratioSize.width), Math.min(maximumSize.height, ratioSize.height));
        }
        window.setSize(ratioSize);
    }

    public static FrameBuilder frame(JComponent component) {
        return new DefaultFrameBuilder(component);
    }

    private static final class DefaultFrameBuilder
    implements FrameBuilder {
        private final JComponent component;
        private final List<WindowListener> windowListeners = new ArrayList<WindowListener>(0);
        private ImageIcon icon;
        private ValueObserver<String> title;
        private Consumer<WindowEvent> onClosing;
        private Consumer<WindowEvent> onClosed;
        private Consumer<WindowEvent> onOpened;
        private Dimension size;
        private boolean resizable = true;
        private Point location;
        private Component locationRelativeTo;
        private int defaultCloseOperation = 1;
        private JMenuBar menuBar;
        private int extendedState = 0;
        private boolean centerFrame;

        private DefaultFrameBuilder(JComponent component) {
            this.component = Objects.requireNonNull(component);
        }

        @Override
        public FrameBuilder title(String title) {
            return this.title((ValueObserver<String>)Value.nullable((Object)title).build());
        }

        @Override
        public FrameBuilder title(ValueObserver<String> title) {
            this.title = Objects.requireNonNull(title);
            return this;
        }

        @Override
        public FrameBuilder icon(ImageIcon icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public FrameBuilder size(Dimension size) {
            this.size = size;
            return this;
        }

        @Override
        public FrameBuilder resizable(boolean resizable) {
            this.resizable = resizable;
            return this;
        }

        @Override
        public FrameBuilder location(Point location) {
            this.location = location;
            return this;
        }

        @Override
        public FrameBuilder locationRelativeTo(Component locationRelativeTo) {
            this.locationRelativeTo = locationRelativeTo;
            return this;
        }

        @Override
        public FrameBuilder defaultCloseOperation(int defaultCloseOperation) {
            this.defaultCloseOperation = defaultCloseOperation;
            return this;
        }

        @Override
        public FrameBuilder onOpened(Consumer<WindowEvent> onOpened) {
            this.onOpened = onOpened;
            return this;
        }

        @Override
        public FrameBuilder onClosed(Consumer<WindowEvent> onClosed) {
            this.onClosed = onClosed;
            return this;
        }

        @Override
        public FrameBuilder onClosing(Consumer<WindowEvent> onClosing) {
            this.onClosing = onClosing;
            return this;
        }

        @Override
        public FrameBuilder menuBar(JMenuBar menuBar) {
            this.menuBar = menuBar;
            return this;
        }

        @Override
        public FrameBuilder extendedState(int extendedState) {
            this.extendedState = extendedState;
            return this;
        }

        @Override
        public FrameBuilder centerFrame(boolean centerFrame) {
            this.centerFrame = centerFrame;
            return this;
        }

        @Override
        public FrameBuilder windowListener(WindowListener windowListener) {
            this.windowListeners.add(Objects.requireNonNull(windowListener));
            return this;
        }

        @Override
        public JFrame build() {
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(this.defaultCloseOperation);
            frame.setLayout(Layouts.borderLayout());
            frame.add((Component)this.component, "Center");
            if (this.title != null) {
                frame.setTitle((String)this.title.get());
                this.title.addConsumer(frame::setTitle);
            }
            if (this.icon != null) {
                frame.setIconImage(this.icon.getImage());
            }
            if (this.size != null) {
                frame.setSize(this.size);
            } else {
                frame.pack();
                Windows.setSizeWithinScreenBounds(frame);
            }
            if (this.menuBar != null) {
                frame.setJMenuBar(this.menuBar);
            }
            frame.setResizable(this.resizable);
            if (this.location != null) {
                frame.setLocation(this.location);
            } else if (this.locationRelativeTo != null) {
                frame.setLocationRelativeTo(this.locationRelativeTo);
            } else if (this.centerFrame) {
                frame.setLocationRelativeTo(null);
            }
            frame.setExtendedState(this.extendedState);
            if (this.onClosing != null || this.onClosed != null || this.onOpened != null) {
                frame.addWindowListener(new FrameListener(this.onClosing, this.onClosed, this.onOpened));
            }
            this.windowListeners.forEach(frame::addWindowListener);
            return frame;
        }

        @Override
        public JFrame show() {
            JFrame frame = this.build();
            frame.setVisible(true);
            return frame;
        }
    }

    private static final class FrameListener
    extends WindowAdapter {
        private final Consumer<WindowEvent> onClosing;
        private final Consumer<WindowEvent> onClosed;
        private final Consumer<WindowEvent> onOpened;

        private FrameListener(Consumer<WindowEvent> onClosing, Consumer<WindowEvent> onClosed, Consumer<WindowEvent> onOpened) {
            this.onClosing = onClosing;
            this.onClosed = onClosed;
            this.onOpened = onOpened;
        }

        @Override
        public void windowOpened(WindowEvent e) {
            if (this.onOpened != null) {
                this.onOpened.accept(e);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (this.onClosing != null) {
                this.onClosing.accept(e);
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (this.onClosed != null) {
                this.onClosed.accept(e);
            }
        }
    }

    public static interface FrameBuilder {
        public FrameBuilder title(String var1);

        public FrameBuilder title(ValueObserver<String> var1);

        public FrameBuilder icon(ImageIcon var1);

        public FrameBuilder size(Dimension var1);

        public FrameBuilder resizable(boolean var1);

        public FrameBuilder location(Point var1);

        public FrameBuilder locationRelativeTo(Component var1);

        public FrameBuilder onOpened(Consumer<WindowEvent> var1);

        public FrameBuilder onClosed(Consumer<WindowEvent> var1);

        public FrameBuilder onClosing(Consumer<WindowEvent> var1);

        public FrameBuilder defaultCloseOperation(int var1);

        public FrameBuilder menuBar(JMenuBar var1);

        public FrameBuilder extendedState(int var1);

        public FrameBuilder centerFrame(boolean var1);

        public FrameBuilder windowListener(WindowListener var1);

        public JFrame build();

        public JFrame show();
    }
}

