/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.key;

import java.util.Objects;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public final class KeyEvents {
    private KeyEvents() {
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Builder builder(int keyCode) {
        return new DefaultBuilder().keyCode(keyCode);
    }

    public static Builder builder(KeyStroke keyStroke) {
        return new DefaultBuilder(keyStroke);
    }

    private static final class DefaultBuilder
    implements Builder {
        private KeyStroke keyStroke;
        private int condition = 0;
        private Action action;

        private DefaultBuilder() {
            this(KeyStroke.getKeyStroke(0, 0, false));
        }

        private DefaultBuilder(KeyStroke keyStroke) {
            this.keyStroke = Objects.requireNonNull(keyStroke);
        }

        @Override
        public Builder keyCode(int keyCode) {
            this.keyStroke = KeyStroke.getKeyStroke(keyCode, this.keyStroke.getModifiers(), this.keyStroke.isOnKeyRelease());
            return this;
        }

        @Override
        public Builder keyChar(char keyChar) {
            this.keyStroke = KeyStroke.getKeyStroke(keyChar, this.keyStroke.getModifiers(), this.keyStroke.isOnKeyRelease());
            return this;
        }

        @Override
        public Builder modifiers(int modifiers) {
            this.keyStroke = KeyStroke.getKeyStroke(this.keyStroke.getKeyCode(), modifiers, this.keyStroke.isOnKeyRelease());
            return this;
        }

        @Override
        public Builder onKeyRelease(boolean onKeyRelease) {
            this.keyStroke = KeyStroke.getKeyStroke(this.keyStroke.getKeyCode(), this.keyStroke.getModifiers(), onKeyRelease);
            return this;
        }

        @Override
        public Builder keyStroke(KeyStroke keyStroke) {
            this.keyStroke = Objects.requireNonNull(keyStroke);
            return this;
        }

        @Override
        public Builder condition(int condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public Builder action(Action action) {
            this.action = Objects.requireNonNull(action);
            return this;
        }

        @Override
        public Builder enable(JComponent ... components) {
            for (JComponent component : Objects.requireNonNull(components)) {
                this.enable(Objects.requireNonNull(component), this.actionMapKey(component));
            }
            return this;
        }

        @Override
        public Builder disable(JComponent ... components) {
            for (JComponent component : Objects.requireNonNull(components)) {
                this.disable(Objects.requireNonNull(component), this.actionMapKey(component));
            }
            return this;
        }

        private Object actionMapKey(JComponent component) {
            if (this.action == null) {
                throw new IllegalStateException("Unable to enable/disable a key event without an associated action");
            }
            return this.createActionMapKey(component);
        }

        private String createActionMapKey(JComponent component) {
            Object actionName = this.action.getValue("Name");
            return component.getClass().getSimpleName() + (String)(actionName == null ? "" : " " + actionName) + " " + this.keyStroke.toString() + " " + this.condition;
        }

        private void enable(JComponent component, Object actionMapKey) {
            component.getActionMap().put(actionMapKey, this.action);
            component.getInputMap(this.condition).put(this.keyStroke, actionMapKey);
            if (component instanceof JComboBox) {
                this.enable((JComponent)((JComboBox)component).getEditor().getEditorComponent(), actionMapKey);
            }
        }

        private void disable(JComponent component, Object actionMapKey) {
            component.getActionMap().put(actionMapKey, null);
            component.getInputMap(this.condition).put(this.keyStroke, null);
            if (component instanceof JComboBox) {
                this.disable((JComponent)((JComboBox)component).getEditor().getEditorComponent(), actionMapKey);
            }
        }
    }

    public static interface Builder {
        public Builder keyCode(int var1);

        public Builder keyChar(char var1);

        public Builder modifiers(int var1);

        public Builder onKeyRelease(boolean var1);

        public Builder keyStroke(KeyStroke var1);

        public Builder condition(int var1);

        public Builder action(Action var1);

        public Builder enable(JComponent ... var1);

        public Builder disable(JComponent ... var1);
    }
}

