/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.key;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.KeyStroke;

final class DefaultKeyboardShortcuts<T extends Enum<T>>
implements KeyboardShortcuts<T> {
    private final Class<T> shortcutClass;
    private final Map<T, Value<KeyStroke>> keyStrokes;

    DefaultKeyboardShortcuts(Class<T> shortcutClass) {
        this(Objects.requireNonNull(shortcutClass), Stream.of((Enum[])shortcutClass.getEnumConstants()).collect(Collectors.toMap(Function.identity(), x$0 -> DefaultKeyboardShortcuts.keyStrokeValue((Enum)x$0))));
    }

    private DefaultKeyboardShortcuts(Class<T> shortcutClass, Map<T, Value<KeyStroke>> keyStrokes) {
        this.shortcutClass = shortcutClass;
        this.keyStrokes = keyStrokes;
    }

    @Override
    public Value<KeyStroke> keyStroke(T shortcut) {
        return this.keyStrokes.get(Objects.requireNonNull(shortcut));
    }

    @Override
    public KeyboardShortcuts<T> copy() {
        return new DefaultKeyboardShortcuts<Enum>(this.shortcutClass, this.keyStrokes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Value.nonNull((Object)((KeyStroke)((Value)entry.getValue()).get())).build())));
    }

    private static <T extends Enum<T>> Value<KeyStroke> keyStrokeValue(T shortcutKey) {
        KeyStroke keyStroke = ((KeyboardShortcuts.Shortcut)((Object)shortcutKey)).defaultKeystroke();
        if (keyStroke == null) {
            throw new IllegalArgumentException("No default keystroke provided for shortcut key: " + shortcutKey);
        }
        return Value.nonNull((Object)keyStroke).build();
    }
}

