/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.swing.common.ui.control.AbstractControlBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.DefaultControls;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Action;

final class ControlsBuilder
extends AbstractControlBuilder<Controls, Controls.Builder>
implements Controls.Builder {
    private final List<Action> controls = new ArrayList<Action>();

    ControlsBuilder() {
    }

    @Override
    public Controls.Builder control(Control control) {
        this.controls.add(Objects.requireNonNull(control));
        return this;
    }

    @Override
    public Controls.Builder control(Control.Builder<?, ?> controlBuilder) {
        this.controls.add((Action)Objects.requireNonNull(controlBuilder).build());
        return this;
    }

    @Override
    public Controls.Builder controls(Control ... controls) {
        this.controls.addAll(Arrays.asList(Objects.requireNonNull(controls)));
        return this;
    }

    @Override
    public Controls.Builder controls(Control.Builder<?, ?> ... controlBuilders) {
        this.controls.addAll(Arrays.stream(controlBuilders).map(new BuildControl()).collect(Collectors.toList()));
        return this;
    }

    @Override
    public Controls.Builder action(Action action) {
        this.controls.add(Objects.requireNonNull(action));
        return this;
    }

    @Override
    public Controls.Builder actions(Action ... actions) {
        this.controls.addAll(Arrays.asList(Objects.requireNonNull(actions)));
        return this;
    }

    @Override
    public Controls.Builder separator() {
        this.controls.add(Controls.SEPARATOR);
        return this;
    }

    @Override
    protected Controls createControl() {
        return new DefaultControls(this.name, this.enabled, this.controls);
    }

    private static final class BuildControl
    implements Function<Control.Builder<?, ?>, Control> {
        private BuildControl() {
        }

        @Override
        public Control apply(Control.Builder<?, ?> builder) {
            return builder.build();
        }
    }
}

