/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.event.Event;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlBuilder;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

abstract class AbstractControl
extends AbstractAction
implements Control {
    private static final String ENABLED = "enabled";
    protected static final List<String> STANDARD_KEYS = Collections.unmodifiableList(Arrays.asList("Name", "ShortDescription", "MnemonicKey", "AcceleratorKey", "SmallIcon", "SwingLargeIconKey"));
    protected final StateObserver enabledObserver;
    private final Enabler enabler = new Enabler();

    AbstractControl(String name, StateObserver enabled) {
        super(name);
        this.enabledObserver = enabled == null ? State.state((boolean)true) : enabled;
        this.enabledObserver.addWeakConsumer((Consumer)this.enabler);
        super.setEnabled((Boolean)this.enabledObserver.get());
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final void setEnabled(boolean newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putValue(String key, Object newValue) {
        if (ENABLED.equals(key)) {
            throw new IllegalArgumentException("Can not set the enabled state of a Control");
        }
        super.putValue(key, newValue);
    }

    @Override
    public final Object getValue(String key) {
        if (ENABLED.equals(key)) {
            return this.enabledObserver.get();
        }
        return super.getValue(key);
    }

    @Override
    public final String getDescription() {
        return (String)this.getValue("ShortDescription");
    }

    @Override
    public final void setDescription(String description) {
        this.putValue("ShortDescription", description);
    }

    @Override
    public final String getName() {
        Object value = this.getValue("Name");
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public final void setName(String name) {
        this.putValue("Name", name);
    }

    @Override
    public final StateObserver enabled() {
        return this.enabledObserver;
    }

    @Override
    public final void setMnemonic(int key) {
        this.putValue("MnemonicKey", key);
    }

    @Override
    public final int getMnemonic() {
        Integer mnemonic = (Integer)this.getValue("MnemonicKey");
        return mnemonic == null ? 0 : mnemonic;
    }

    @Override
    public final void setKeyStroke(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    @Override
    public final KeyStroke getKeyStroke() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    @Override
    public final void setSmallIcon(Icon smallIcon) {
        this.putValue("SmallIcon", smallIcon);
    }

    @Override
    public final Icon getSmallIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    @Override
    public final void setLargeIcon(Icon largeIcon) {
        this.putValue("SwingLargeIconKey", largeIcon);
    }

    @Override
    public final Icon getLargeIcon() {
        return (Icon)this.getValue("SwingLargeIconKey");
    }

    @Override
    public final void setBackground(Color background) {
        this.putValue("Background", background);
    }

    @Override
    public final Color getBackground() {
        return (Color)this.getValue("Background");
    }

    @Override
    public final void setForeground(Color foreground) {
        this.putValue("Foreground", foreground);
    }

    @Override
    public final Color getForeground() {
        return (Color)this.getValue("Foreground");
    }

    @Override
    public final void setFont(Font font) {
        this.putValue("Font", font);
    }

    @Override
    public final Font getFont() {
        return (Font)this.getValue("Font");
    }

    @Override
    public final <B extends Control.Builder<Control, B>> Control.Builder<Control, B> copy(Control.Command command) {
        return this.createBuilder(command, null);
    }

    @Override
    public final <B extends Control.Builder<Control, B>> Control.Builder<Control, B> copy(Control.ActionCommand actionCommand) {
        return this.createBuilder(null, actionCommand);
    }

    @Override
    public final <B extends Control.Builder<Control, B>> Control.Builder<Control, B> copy(Event<ActionEvent> event) {
        Objects.requireNonNull(event);
        return this.copy(arg_0 -> event.accept(arg_0));
    }

    private <B extends Control.Builder<Control, B>> Control.Builder<Control, B> createBuilder(Control.Command command, Control.ActionCommand actionCommand) {
        ControlBuilder builder = command == null ? new ControlBuilder(actionCommand) : new ControlBuilder(command);
        builder.enabled(this.enabledObserver).description(this.getDescription()).name(this.getName()).mnemonic((char)this.getMnemonic()).keyStroke(this.getKeyStroke()).smallIcon(this.getSmallIcon()).largeIcon(this.getLargeIcon());
        Arrays.stream(this.getKeys()).filter(key -> !STANDARD_KEYS.contains(key)).map(String.class::cast).forEach(key -> builder.value((String)key, this.getValue((String)key)));
        return builder;
    }

    private final class Enabler
    implements Consumer<Boolean> {
        private Enabler() {
        }

        @Override
        public void accept(Boolean enabled) {
            AbstractControl.super.setEnabled(enabled);
        }
    }
}

