/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.list;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.list.AbstractListBuilder;
import is.codion.swing.common.ui.component.list.ListBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import javax.swing.JList;
import javax.swing.ListModel;

final class DefaultListSelectedItemBuilder<T>
extends AbstractListBuilder<T, T, ListBuilder.SelectedItem<T>>
implements ListBuilder.SelectedItem<T> {
    DefaultListSelectedItemBuilder(ListModel<T> listModel, Value<T> linkedValue) {
        super(listModel, linkedValue);
    }

    @Override
    protected JList<T> createComponent() {
        JList list = this.createList();
        list.setSelectionMode(0);
        return list;
    }

    @Override
    protected ComponentValue<T, JList<T>> createComponentValue(JList<T> component) {
        return new ListSelectedItemValue<T>(component);
    }

    @Override
    protected void setInitialValue(JList<T> component, T initialValue) {
        ListSelectedItemValue.selectValue(component, initialValue);
    }

    private static final class ListSelectedItemValue<T>
    extends AbstractComponentValue<T, JList<T>> {
        private ListSelectedItemValue(JList<T> list) {
            super(list);
            list.addListSelectionListener(e -> this.notifyListeners());
        }

        @Override
        protected T getComponentValue() {
            List selectedValuesList = ((JList)this.component()).getSelectedValuesList();
            return selectedValuesList.isEmpty() ? null : (T)selectedValuesList.get(0);
        }

        @Override
        protected void setComponentValue(T value) {
            ListSelectedItemValue.selectValue((JList)this.component(), value);
        }

        private static <T> void selectValue(JList<T> list, T value) {
            ListSelectedItemValue.indexOf(list, value).ifPresent(list::setSelectedIndex);
        }

        private static <T> OptionalInt indexOf(JList<T> list, T element) {
            ListModel<T> model = list.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!Objects.equals(model.getElementAt(i), element)) continue;
                return OptionalInt.of(i);
            }
            return OptionalInt.empty();
        }
    }
}

