/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.combobox;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.combobox.ComboBoxMouseWheelListener;
import is.codion.swing.common.ui.component.combobox.Completion;
import is.codion.swing.common.ui.component.combobox.DefaultComboBoxBuilder;
import java.awt.event.ItemListener;
import java.util.Objects;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;

public interface ComboBoxBuilder<T, C extends JComboBox<T>, B extends ComboBoxBuilder<T, C, B>>
extends ComponentBuilder<T, C, B> {
    public B editable(boolean var1);

    public B completionMode(Completion.Mode var1);

    public B renderer(ListCellRenderer<T> var1);

    public B editor(ComboBoxEditor var1);

    public B mouseWheelScrolling(boolean var1);

    public B mouseWheelScrollingWithWrapAround(boolean var1);

    public B maximumRowCount(int var1);

    public B moveCaretToFrontOnSelection(boolean var1);

    public B popupWidth(int var1);

    public B itemListener(ItemListener var1);

    public static <T, C extends JComboBox<T>, B extends ComboBoxBuilder<T, C, B>> ComboBoxBuilder<T, C, B> builder(ComboBoxModel<T> comboBoxModel) {
        return new DefaultComboBoxBuilder(comboBoxModel, null);
    }

    public static <T, C extends JComboBox<T>, B extends ComboBoxBuilder<T, C, B>> ComboBoxBuilder<T, C, B> builder(ComboBoxModel<T> comboBoxModel, Value<T> linkedValue) {
        return new DefaultComboBoxBuilder(comboBoxModel, Objects.requireNonNull(linkedValue));
    }

    public static void enableMouseWheelSelection(JComboBox<?> comboBox) {
        Objects.requireNonNull(comboBox).addMouseWheelListener(new ComboBoxMouseWheelListener(comboBox.getModel(), false));
    }

    public static void enableMouseWheelSelectionWithWrapAround(JComboBox<?> comboBox) {
        comboBox.addMouseWheelListener(new ComboBoxMouseWheelListener(comboBox.getModel(), true));
    }
}

