/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.button.ControlPanelBuilder;
import is.codion.swing.common.ui.component.button.RadioButtonBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonType;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Controls;
import java.awt.Dimension;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.JComponent;

abstract class AbstractControlPanelBuilder<C extends JComponent, B extends ControlPanelBuilder<C, B>>
extends AbstractComponentBuilder<Void, C, B>
implements ControlPanelBuilder<C, B> {
    private final Controls controls = Controls.controls();
    private final ButtonBuilder<?, ?, ?> buttonBuilder = ButtonBuilder.builder();
    private final ToggleButtonBuilder<?, ?> toggleButtonBuilder = ToggleButtonBuilder.builder();
    private final CheckBoxBuilder checkBoxBuilder = CheckBoxBuilder.builder();
    private final RadioButtonBuilder radioButtonBuilder = RadioButtonBuilder.builder();
    private int orientation = 0;
    private ToggleButtonType toggleButtonType = ToggleButtonType.BUTTON;

    protected AbstractControlPanelBuilder(Controls controls) {
        if (controls != null) {
            this.controls.addAll(controls);
        }
    }

    @Override
    public final B orientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("Unknown orientation value: " + orientation);
        }
        this.orientation = orientation;
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B action(Action action) {
        this.controls.add(Objects.requireNonNull(action));
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B controls(Controls controls) {
        this.controls.addAll(Objects.requireNonNull(controls));
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B separator() {
        this.controls.addSeparator();
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B includeButtonText(boolean includeButtonText) {
        this.buttonBuilder.includeText(includeButtonText);
        this.toggleButtonBuilder.includeText(includeButtonText);
        this.checkBoxBuilder.includeText(includeButtonText);
        this.radioButtonBuilder.includeText(includeButtonText);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B preferredButtonSize(Dimension preferredButtonSize) {
        this.buttonBuilder.preferredSize(preferredButtonSize);
        this.toggleButtonBuilder.preferredSize(preferredButtonSize);
        this.checkBoxBuilder.preferredSize(preferredButtonSize);
        this.radioButtonBuilder.preferredSize(preferredButtonSize);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B buttonsFocusable(boolean buttonsFocusable) {
        this.buttonBuilder.focusable(buttonsFocusable);
        this.toggleButtonBuilder.focusable(buttonsFocusable);
        this.checkBoxBuilder.focusable(buttonsFocusable);
        this.radioButtonBuilder.focusable(buttonsFocusable);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B toggleButtonType(ToggleButtonType toggleButtonType) {
        this.toggleButtonType = Objects.requireNonNull(toggleButtonType);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B buttonBuilder(Consumer<ButtonBuilder<?, ?, ?>> buttonBuilder) {
        Objects.requireNonNull(buttonBuilder).accept(this.buttonBuilder);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public final B toggleButtonBuilder(Consumer<ToggleButtonBuilder<?, ?>> toggleButtonBuilder) {
        Objects.requireNonNull(toggleButtonBuilder).accept(this.toggleButtonBuilder);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public B checkBoxBuilder(Consumer<CheckBoxBuilder> checkBoxBuilder) {
        Objects.requireNonNull(checkBoxBuilder).accept(this.checkBoxBuilder);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    public B radioButtonBuilder(Consumer<RadioButtonBuilder> radioButtonBuilder) {
        Objects.requireNonNull(radioButtonBuilder).accept(this.radioButtonBuilder);
        return (B)((ControlPanelBuilder)this.self());
    }

    @Override
    protected final ComponentValue<Void, C> createComponentValue(C component) {
        throw new UnsupportedOperationException("A ComponentValue can not be based on this component type");
    }

    @Override
    protected final void setInitialValue(C component, Void initialValue) {
    }

    protected final Controls controls() {
        return this.controls;
    }

    protected final int orientation() {
        return this.orientation;
    }

    protected final ButtonBuilder<?, ?, ?> buttonBuilder() {
        return this.buttonBuilder;
    }

    protected final ToggleButtonBuilder<?, ?> toggleButtonBuilder() {
        switch (this.toggleButtonType) {
            case CHECKBOX: {
                return this.checkBoxBuilder;
            }
            case BUTTON: {
                return this.toggleButtonBuilder;
            }
            case RADIO_BUTTON: {
                return this.radioButtonBuilder;
            }
        }
        throw new IllegalArgumentException("Unknown toggle button type: " + this.toggleButtonType);
    }
}

