/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.i18n.Messages;
import is.codion.common.model.CancelException;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.DefaultOkCancelDialogBuilder;
import is.codion.swing.common.ui.dialog.LoginDialogBuilder;
import is.codion.swing.common.ui.dialog.LoginPanel;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;

final class DefaultLoginDialogBuilder
extends AbstractDialogBuilder<LoginDialogBuilder>
implements LoginDialogBuilder {
    private static final int DEFAULT_FIELD_COLUMNS = 8;
    private User defaultUser;
    private LoginDialogBuilder.LoginValidator validator = new NoLoginValidation();
    private JComponent southComponent;
    private int inputFieldColumns = 8;

    DefaultLoginDialogBuilder() {
        this.titleProvider((ValueObserver<String>)Value.nullable((Object)Messages.login()).build());
    }

    @Override
    public LoginDialogBuilder defaultUser(User defaultUser) {
        this.defaultUser = defaultUser;
        return this;
    }

    @Override
    public LoginDialogBuilder validator(LoginDialogBuilder.LoginValidator validator) {
        this.validator = Objects.requireNonNull(validator);
        return this;
    }

    @Override
    public LoginDialogBuilder southComponent(JComponent southComponent) {
        this.southComponent = southComponent;
        return this;
    }

    @Override
    public LoginDialogBuilder inputFieldColumns(int inputFieldColumns) {
        this.inputFieldColumns = inputFieldColumns;
        return this;
    }

    @Override
    public User show() {
        User user;
        JFrame dummyFrame = null;
        if (this.owner == null && DefaultLoginDialogBuilder.isWindows()) {
            dummyFrame = DefaultLoginDialogBuilder.createDummyFrame(this.titleProvider == null ? null : (String)this.titleProvider.get(), this.icon);
            this.owner = dummyFrame;
        }
        LoginPanel loginPanel = new LoginPanel(this.defaultUser, this.validator, this.icon, this.southComponent, this.inputFieldColumns);
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)new DefaultOkCancelDialogBuilder(loginPanel).owner(this.owner)).resizable(false)).titleProvider((ValueObserver<String>)this.titleProvider)).icon(this.icon)).okAction(loginPanel.okControl()).cancelAction(loginPanel.cancelControl()).onShown(dialog -> loginPanel.requestInitialFocus())).show();
        if (dummyFrame != null) {
            dummyFrame.dispose();
        }
        if ((user = loginPanel.user()) == null) {
            throw new CancelException();
        }
        return user;
    }

    private static JFrame createDummyFrame(String title, ImageIcon icon) {
        JFrame frame = new JFrame(title);
        frame.setUndecorated(true);
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
        return frame;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static final class NoLoginValidation
    implements LoginDialogBuilder.LoginValidator {
        private NoLoginValidation() {
        }

        @Override
        public void validate(User user) {
        }
    }
}

