/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.event.EventObserver;
import is.codion.common.state.State;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.DisposeDialogAction;
import is.codion.swing.common.ui.dialog.DisposeDialogOnEscapeAction;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;

final class DefaultComponentDialogBuilder
extends AbstractDialogBuilder<ComponentDialogBuilder>
implements ComponentDialogBuilder {
    private final JComponent component;
    private boolean modal = true;
    private boolean resizable = true;
    private Dimension size;
    private Action enterAction;
    private Consumer<JDialog> onShown;
    private Consumer<WindowEvent> onOpened;
    private Consumer<WindowEvent> onClosed;
    private EventObserver<?> closeEvent;
    private Consumer<State> confirmCloseListener;
    private boolean disposeOnEscape = true;

    DefaultComponentDialogBuilder(JComponent component) {
        this.component = Objects.requireNonNull(component);
    }

    @Override
    public ComponentDialogBuilder modal(boolean modal) {
        this.modal = modal;
        return this;
    }

    @Override
    public ComponentDialogBuilder resizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    @Override
    public ComponentDialogBuilder size(Dimension size) {
        this.size = Objects.requireNonNull(size);
        return this;
    }

    @Override
    public ComponentDialogBuilder enterAction(Action enterAction) {
        this.enterAction = Objects.requireNonNull(enterAction);
        return this;
    }

    @Override
    public ComponentDialogBuilder closeEvent(EventObserver<?> closeEvent) {
        this.closeEvent = closeEvent;
        return this;
    }

    @Override
    public ComponentDialogBuilder confirmCloseListener(Consumer<State> confirmCloseListener) {
        this.confirmCloseListener = confirmCloseListener;
        return this;
    }

    @Override
    public ComponentDialogBuilder disposeOnEscape(boolean disposeOnEscape) {
        this.disposeOnEscape = disposeOnEscape;
        return this;
    }

    @Override
    public ComponentDialogBuilder onShown(Consumer<JDialog> onShown) {
        this.onShown = onShown;
        return this;
    }

    @Override
    public ComponentDialogBuilder onOpened(Consumer<WindowEvent> onOpened) {
        this.onOpened = Objects.requireNonNull(onOpened);
        return this;
    }

    @Override
    public ComponentDialogBuilder onClosed(Consumer<WindowEvent> onClosed) {
        this.onClosed = Objects.requireNonNull(onClosed);
        return this;
    }

    @Override
    public JDialog show() {
        JDialog dialog = this.build();
        dialog.setVisible(true);
        return dialog;
    }

    @Override
    public JDialog build() {
        JDialog dialog = DefaultComponentDialogBuilder.createDialog(this.owner, (ValueObserver<String>)this.titleProvider, this.icon, this.component, this.size, this.locationRelativeTo, this.location, this.modal, this.resizable, this.onShown, this.keyEventBuilders);
        if (this.enterAction != null) {
            KeyEvents.builder(10).condition(1).action(this.enterAction).enable(dialog.getRootPane());
        }
        DisposeDialogAction disposeAction = new DisposeDialogAction(new DialogSupplier(dialog), this.confirmCloseListener);
        dialog.addWindowListener(new DialogListener(disposeAction, this.onClosed, this.onOpened));
        if (this.closeEvent == null) {
            dialog.setDefaultCloseOperation(2);
            if (this.disposeOnEscape) {
                KeyEvents.builder(27).condition(2).action(new DisposeDialogOnEscapeAction(dialog, this.confirmCloseListener)).enable(dialog.getRootPane());
            }
        } else {
            this.closeEvent.addListener((Runnable)new CloseListener(disposeAction));
        }
        return dialog;
    }

    static JDialog createDialog(Window owner, ValueObserver<String> titleProvider, ImageIcon icon, JComponent component, Dimension size, Component locationRelativeTo, Point location, boolean modal, boolean resizable, Consumer<JDialog> onShown, List<KeyEvents.Builder> keyEventBuilders) {
        JDialog dialog = new JDialog(owner);
        if (titleProvider != null) {
            dialog.setTitle((String)titleProvider.get());
            titleProvider.addConsumer((Consumer)new SetDialogTitle(dialog));
        }
        if (icon != null) {
            dialog.setIconImage(icon.getImage());
        }
        dialog.setLayout(Layouts.borderLayout());
        dialog.add((Component)component, "Center");
        if (size != null) {
            dialog.setSize(size);
        } else {
            dialog.pack();
        }
        if (location != null) {
            dialog.setLocation(location);
        } else if (locationRelativeTo != null) {
            dialog.setLocationRelativeTo(locationRelativeTo);
        } else {
            dialog.setLocationRelativeTo(owner);
        }
        dialog.setModal(modal);
        dialog.setResizable(resizable);
        keyEventBuilders.forEach(new EnableKeyEvent(dialog));
        if (onShown != null) {
            dialog.addComponentListener(new OnShownAdapter(dialog, onShown));
        }
        return dialog;
    }

    private static final class DialogSupplier
    implements Supplier<JDialog> {
        private final JDialog dialog;

        private DialogSupplier(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public JDialog get() {
            return this.dialog;
        }
    }

    private static final class DialogListener
    extends WindowAdapter {
        private final Action disposeAction;
        private final Consumer<WindowEvent> onClosed;
        private final Consumer<WindowEvent> onOpened;

        private DialogListener(Action disposeAction, Consumer<WindowEvent> onClosed, Consumer<WindowEvent> onOpened) {
            this.disposeAction = disposeAction;
            this.onClosed = onClosed;
            this.onOpened = onOpened;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.disposeAction.actionPerformed(null);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (this.onClosed != null) {
                this.onClosed.accept(e);
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
            if (this.onOpened != null) {
                this.onOpened.accept(e);
            }
        }
    }

    private static final class CloseListener
    implements Runnable {
        private final Action disposeAction;

        private CloseListener(Action disposeAction) {
            this.disposeAction = disposeAction;
        }

        @Override
        public void run() {
            this.disposeAction.actionPerformed(null);
        }
    }

    private static final class SetDialogTitle
    implements Consumer<String> {
        private final JDialog dialog;

        private SetDialogTitle(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void accept(String title) {
            this.dialog.setTitle(title);
        }
    }

    private static final class EnableKeyEvent
    implements Consumer<KeyEvents.Builder> {
        private final JDialog dialog;

        private EnableKeyEvent(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void accept(KeyEvents.Builder builder) {
            builder.enable(this.dialog.getRootPane());
        }
    }

    private static final class OnShownAdapter
    extends ComponentAdapter {
        private final JDialog dialog;
        private final Consumer<JDialog> onShown;

        private OnShownAdapter(JDialog dialog, Consumer<JDialog> onShown) {
            this.dialog = dialog;
            this.onShown = onShown;
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.onShown.accept(this.dialog);
        }
    }
}

