/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.text.AbstractTextComponentBuilder;
import is.codion.swing.common.ui.component.text.DefaultTextComponentValue;
import is.codion.swing.common.ui.component.text.TextAreaBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.util.Objects;
import javax.swing.JTextArea;
import javax.swing.text.Document;

final class DefaultTextAreaBuilder
extends AbstractTextComponentBuilder<String, JTextArea, TextAreaBuilder>
implements TextAreaBuilder {
    private int columns;
    private int rows;
    private int tabSize;
    private boolean lineWrap = false;
    private boolean wrapStyleWord = false;
    private boolean autoscrolls = false;
    private Document document;

    DefaultTextAreaBuilder(Value<String> linkedValue) {
        super(linkedValue);
    }

    @Override
    public TextAreaBuilder rows(int rows) {
        this.rows = rows;
        return this;
    }

    @Override
    public TextAreaBuilder rowsColumns(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        return this;
    }

    @Override
    public TextAreaBuilder tabSize(int tabSize) {
        this.tabSize = tabSize;
        return this;
    }

    @Override
    public TextAreaBuilder lineWrap(boolean lineWrap) {
        this.lineWrap = lineWrap;
        return this;
    }

    @Override
    public TextAreaBuilder wrapStyleWord(boolean wrapStyleWord) {
        this.wrapStyleWord = wrapStyleWord;
        return this;
    }

    @Override
    public TextAreaBuilder autoscrolls(boolean autoscrolls) {
        this.autoscrolls = autoscrolls;
        return this;
    }

    @Override
    public TextAreaBuilder document(Document document) {
        this.document = Objects.requireNonNull(document);
        return this;
    }

    @Override
    protected JTextArea createTextComponent() {
        JTextArea textArea = new JTextArea(this.rows, this.columns);
        if (this.document != null) {
            textArea.setDocument(this.document);
        } else {
            this.document = textArea.getDocument();
        }
        textArea.setAutoscrolls(this.autoscrolls);
        textArea.setLineWrap(this.lineWrap);
        textArea.setWrapStyleWord(this.wrapStyleWord);
        if (this.tabSize > 0) {
            textArea.setTabSize(this.tabSize);
        }
        return textArea;
    }

    @Override
    protected ComponentValue<String, JTextArea> createComponentValue(JTextArea component) {
        return new DefaultTextComponentValue<String, JTextArea>(component, null, this.updateOn);
    }
}

