/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.i18n.Messages;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.state.State;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.FilteredTableColumnComponentPanel;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public final class FilteredTableConditionPanel<C>
extends JPanel {
    private final TableConditionModel<C> conditionModel;
    private final FilteredTableColumnComponentPanel<C, ColumnConditionPanel<C, ?>> componentPanel;
    private final State advanced = State.builder().consumer(this::onAdvancedChanged).build();
    private final Event<C> focusGainedEvent = Event.event();

    private FilteredTableConditionPanel(TableConditionModel<C> conditionModel, FilteredTableColumnModel<C> columnModel, ColumnConditionPanel.Factory<C> conditionPanelFactory) {
        this.conditionModel = Objects.requireNonNull(conditionModel);
        this.componentPanel = FilteredTableColumnComponentPanel.filteredTableColumnComponentPanel(Objects.requireNonNull(columnModel), this.createConditionPanels(columnModel, Objects.requireNonNull(conditionPanelFactory)));
        this.setLayout(new BorderLayout());
        this.add(this.componentPanel, "Center");
        this.componentPanel.components().values().forEach(panel -> panel.focusGainedEvent().addConsumer(this.focusGainedEvent));
    }

    public Collection<ColumnConditionPanel<C, ?>> conditionPanels() {
        return this.componentPanel.components().values();
    }

    public State advanced() {
        return this.advanced;
    }

    public <T> Optional<ColumnConditionPanel<C, T>> conditionPanel(C columnIdentifier) {
        return Optional.ofNullable(this.componentPanel.components().get(Objects.requireNonNull(columnIdentifier)));
    }

    public Controls controls() {
        return (Controls)Controls.builder().control((Control.Builder<?, ?>)ToggleControl.builder(this.advanced).name(Messages.advanced())).control((Control.Builder<?, ?>)Control.builder(this::clearConditions).name(Messages.clear())).build();
    }

    public EventObserver<C> focusGainedEvent() {
        return this.focusGainedEvent.observer();
    }

    public static <C> FilteredTableConditionPanel<C> filteredTableConditionPanel(TableConditionModel<C> conditionModel, FilteredTableColumnModel<C> columnModel, ColumnConditionPanel.Factory<C> conditionPanelFactory) {
        return new FilteredTableConditionPanel<C>(conditionModel, columnModel, conditionPanelFactory);
    }

    private void clearConditions() {
        this.componentPanel.components().values().stream().map(ColumnConditionPanel::model).forEach(ColumnConditionModel::clear);
    }

    private void onAdvancedChanged(boolean advancedView) {
        this.componentPanel.components().forEach((column, panel) -> panel.advanced().set((Object)advancedView));
    }

    private Map<C, ColumnConditionPanel<C, ?>> createConditionPanels(FilteredTableColumnModel<C> columnModel, ColumnConditionPanel.Factory<C> conditionPanelFactory) {
        return columnModel.columns().stream().map(column -> (ColumnConditionModel)this.conditionModel.conditionModels().get(column.getIdentifier())).filter(Objects::nonNull).map(columnConditionModel -> this.createConditionPanel(conditionPanelFactory, (ColumnConditionModel<C, ?>)columnConditionModel, (FilteredTableColumn<C>)columnModel.column(columnConditionModel.columnIdentifier()))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(conditionPanel -> conditionPanel.model().columnIdentifier(), Function.identity()));
    }

    private Optional<ColumnConditionPanel<C, ?>> createConditionPanel(ColumnConditionPanel.Factory<C> conditionPanelFactory, ColumnConditionModel<C, ?> columnConditionModel, FilteredTableColumn<C> column) {
        return conditionPanelFactory.createConditionPanel(columnConditionModel).map(conditionPanel -> this.configureHorizontalAlignment((ColumnConditionPanel<C, ?>)conditionPanel, column.getCellRenderer()));
    }

    private ColumnConditionPanel<C, ?> configureHorizontalAlignment(ColumnConditionPanel<C, ?> columnConditionPanel, TableCellRenderer cellRenderer) {
        if (cellRenderer instanceof DefaultTableCellRenderer) {
            int horizontalAlignment = ((DefaultTableCellRenderer)cellRenderer).getHorizontalAlignment();
            Stream.of(columnConditionPanel.equalField(), columnConditionPanel.lowerBoundField(), columnConditionPanel.upperBoundField()).filter(JTextField.class::isInstance).map(JTextField.class::cast).forEach(textField -> textField.setHorizontalAlignment(horizontalAlignment));
        }
        return columnConditionPanel;
    }
}

