/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.tabbedpane;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.tabbedpane.TabbedPaneBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;

final class DefaultTabbedPaneBuilder
extends AbstractComponentBuilder<Void, JTabbedPane, TabbedPaneBuilder>
implements TabbedPaneBuilder {
    private int tabPlacement = 1;
    private int tabLayoutPolicy = 0;
    private final List<DefaultTabBuilder> tabBuilders = new ArrayList<DefaultTabBuilder>();
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    DefaultTabbedPaneBuilder() {
    }

    @Override
    public TabbedPaneBuilder tabPlacement(int tabPlacement) {
        this.tabPlacement = tabPlacement;
        return this;
    }

    @Override
    public TabbedPaneBuilder tabLayoutPolicy(int tabLayoutPolicy) {
        this.tabLayoutPolicy = tabLayoutPolicy;
        return this;
    }

    @Override
    public TabbedPaneBuilder changeListener(ChangeListener changeListener) {
        this.changeListeners.add(Objects.requireNonNull(changeListener));
        return this;
    }

    @Override
    public TabbedPaneBuilder tab(String title, JComponent component) {
        new DefaultTabBuilder(this, Objects.requireNonNull(title), component).add();
        return this;
    }

    @Override
    public TabbedPaneBuilder.TabBuilder tabBuilder(JComponent component) {
        return new DefaultTabBuilder(this, null, component);
    }

    @Override
    public TabbedPaneBuilder.TabBuilder tabBuilder(String title, JComponent component) {
        return new DefaultTabBuilder(this, Objects.requireNonNull(title), component);
    }

    @Override
    protected JTabbedPane createComponent() {
        JTabbedPane tabbedPane = new JTabbedPane(this.tabPlacement, this.tabLayoutPolicy);
        this.tabBuilders.forEach(tabBuilder -> {
            int tabIndex = tabbedPane.getTabCount();
            tabbedPane.addTab(tabBuilder.title, tabBuilder.icon, tabBuilder.component, tabBuilder.toolTipText);
            if (tabBuilder.mnemonic != 0) {
                tabbedPane.setMnemonicAt(tabIndex, tabBuilder.mnemonic);
            }
            if (tabBuilder.tabComponent != null) {
                tabbedPane.setTabComponentAt(tabIndex, tabBuilder.tabComponent);
            }
        });
        this.changeListeners.forEach(new AddChangeListener(tabbedPane));
        return tabbedPane;
    }

    @Override
    protected ComponentValue<Void, JTabbedPane> createComponentValue(JTabbedPane component) {
        throw new UnsupportedOperationException("A ComponentValue can not be based on a JTabbedPane");
    }

    @Override
    protected void setInitialValue(JTabbedPane component, Void initialValue) {
    }

    private static final class DefaultTabBuilder
    implements TabbedPaneBuilder.TabBuilder {
        private final DefaultTabbedPaneBuilder tabbedPaneBuilder;
        private final JComponent component;
        private final String title;
        private int mnemonic;
        private String toolTipText;
        private Icon icon;
        private JComponent tabComponent;

        private DefaultTabBuilder(DefaultTabbedPaneBuilder tabbedPaneBuilder, String title, JComponent component) {
            this.tabbedPaneBuilder = tabbedPaneBuilder;
            this.title = title;
            this.component = Objects.requireNonNull(component);
        }

        @Override
        public TabbedPaneBuilder.TabBuilder mnemonic(int mnemonic) {
            this.mnemonic = mnemonic;
            return this;
        }

        @Override
        public TabbedPaneBuilder.TabBuilder toolTipText(String toolTipText) {
            this.toolTipText = toolTipText;
            return this;
        }

        @Override
        public TabbedPaneBuilder.TabBuilder icon(Icon icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public TabbedPaneBuilder.TabBuilder tabComponent(JComponent tabComponent) {
            this.tabComponent = tabComponent;
            return this;
        }

        @Override
        public TabbedPaneBuilder add() {
            this.tabbedPaneBuilder.tabBuilders.add(this);
            return this.tabbedPaneBuilder;
        }
    }

    private static final class AddChangeListener
    implements Consumer<ChangeListener> {
        private final JTabbedPane tabbedPane;

        private AddChangeListener(JTabbedPane tabbedPane) {
            this.tabbedPane = tabbedPane;
        }

        @Override
        public void accept(ChangeListener listener) {
            this.tabbedPane.addChangeListener(listener);
        }
    }
}

