/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.slider;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.slider.IntegerSliderValue;
import is.codion.swing.common.ui.component.slider.SliderBuilder;
import is.codion.swing.common.ui.component.slider.SliderMouseWheelListener;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.util.Objects;
import javax.swing.BoundedRangeModel;
import javax.swing.JSlider;

final class DefaultSliderBuilder
extends AbstractComponentBuilder<Integer, JSlider, SliderBuilder>
implements SliderBuilder {
    private final BoundedRangeModel boundedRangeModel;
    private int minorTickSpacing;
    private int majorTickSpacing;
    private boolean snapToTicks = false;
    private boolean paintTicks = false;
    private boolean paintTrack = true;
    private boolean paintLabels = false;
    private boolean inverted = false;
    private int orientation = 0;
    private boolean mouseWheelScrolling = true;
    private boolean mouseWheelScrollingReversed = false;

    DefaultSliderBuilder(BoundedRangeModel boundedRangeModel, Value<Integer> linkedValue) {
        super(linkedValue);
        this.boundedRangeModel = Objects.requireNonNull(boundedRangeModel);
    }

    @Override
    public SliderBuilder minorTickSpacing(int minorTickSpacing) {
        this.minorTickSpacing = minorTickSpacing;
        return this;
    }

    @Override
    public SliderBuilder majorTickSpacing(int majorTickSpacing) {
        this.majorTickSpacing = majorTickSpacing;
        return this;
    }

    @Override
    public SliderBuilder snapToTicks(boolean snapToTicks) {
        this.snapToTicks = snapToTicks;
        return this;
    }

    @Override
    public SliderBuilder paintTicks(boolean paintTicks) {
        this.paintTicks = paintTicks;
        return this;
    }

    @Override
    public SliderBuilder paintTrack(boolean paintTrack) {
        this.paintTrack = paintTrack;
        return this;
    }

    @Override
    public SliderBuilder paintLabels(boolean paintLabels) {
        this.paintLabels = paintLabels;
        return this;
    }

    @Override
    public SliderBuilder inverted(boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    @Override
    public SliderBuilder orientation(int orientation) {
        this.orientation = orientation;
        return this;
    }

    @Override
    public SliderBuilder mouseWheelScrolling(boolean mouseWheelScrolling) {
        this.mouseWheelScrolling = mouseWheelScrolling;
        if (mouseWheelScrolling) {
            this.mouseWheelScrollingReversed = false;
        }
        return this;
    }

    @Override
    public SliderBuilder mouseWheelScrollingReversed(boolean mouseWheelScrollingReversed) {
        this.mouseWheelScrollingReversed = mouseWheelScrollingReversed;
        if (mouseWheelScrollingReversed) {
            this.mouseWheelScrolling = false;
        }
        return this;
    }

    @Override
    protected JSlider createComponent() {
        JSlider slider = new JSlider(this.boundedRangeModel);
        if (this.minorTickSpacing > 0) {
            slider.setMinorTickSpacing(this.minorTickSpacing);
        }
        if (this.majorTickSpacing > 0) {
            slider.setMajorTickSpacing(this.majorTickSpacing);
        }
        slider.setSnapToTicks(this.snapToTicks);
        slider.setPaintTicks(this.paintTicks);
        slider.setPaintTrack(this.paintTrack);
        slider.setPaintLabels(this.paintLabels);
        slider.setInverted(this.inverted);
        slider.setOrientation(this.orientation);
        if (this.mouseWheelScrolling) {
            slider.addMouseWheelListener(new SliderMouseWheelListener(this.boundedRangeModel, false));
        }
        if (this.mouseWheelScrollingReversed) {
            slider.addMouseWheelListener(new SliderMouseWheelListener(this.boundedRangeModel, true));
        }
        return slider;
    }

    @Override
    protected ComponentValue<Integer, JSlider> createComponentValue(JSlider component) {
        return new IntegerSliderValue(component);
    }

    @Override
    protected void setInitialValue(JSlider component, Integer initialValue) {
        component.setValue(initialValue);
    }
}

