/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.list;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.list.AbstractListBuilder;
import is.codion.swing.common.ui.component.list.ListBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.util.HashSet;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListModel;

final class DefaultListSelectedItemsBuilder<T>
extends AbstractListBuilder<T, Set<T>, ListBuilder.SelectedItems<T>>
implements ListBuilder.SelectedItems<T> {
    DefaultListSelectedItemsBuilder(ListModel<T> listModel, Value<Set<T>> linkedValue) {
        super(listModel, linkedValue);
    }

    @Override
    protected JList<T> createComponent() {
        JList list = this.createList();
        list.setSelectionMode(2);
        return list;
    }

    @Override
    protected ComponentValue<Set<T>, JList<T>> createComponentValue(JList<T> component) {
        return new ListSelectedItemsValue<T>(component);
    }

    @Override
    protected void setInitialValue(JList<T> component, Set<T> initialValue) {
        ListSelectedItemsValue.selectValues(component, initialValue);
    }

    private static final class ListSelectedItemsValue<T>
    extends AbstractComponentValue<Set<T>, JList<T>> {
        private ListSelectedItemsValue(JList<T> list) {
            super(list);
            list.addListSelectionListener(e -> this.notifyListeners());
        }

        @Override
        protected Set<T> getComponentValue() {
            return new HashSet(((JList)this.component()).getSelectedValuesList());
        }

        @Override
        protected void setComponentValue(Set<T> value) {
            ListSelectedItemsValue.selectValues((JList)this.component(), value);
        }

        private static <T> void selectValues(JList<T> list, Set<T> valueSet) {
            list.setSelectedIndices(valueSet.stream().map(value -> ListSelectedItemsValue.indexOf(list, value)).filter(OptionalInt::isPresent).mapToInt(OptionalInt::getAsInt).toArray());
        }

        private static <T> OptionalInt indexOf(JList<T> list, T element) {
            ListModel<T> model = list.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!Objects.equals(model.getElementAt(i), element)) continue;
                return OptionalInt.of(i);
            }
            return OptionalInt.empty();
        }
    }
}

