/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.list;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.list.AddListSelectionListener;
import is.codion.swing.common.ui.component.list.ListBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

abstract class AbstractListBuilder<T, V, B extends ListBuilder<T, V, B>>
extends AbstractComponentBuilder<V, JList<T>, B>
implements ListBuilder<T, V, B> {
    private final ListModel<T> listModel;
    private final List<ListSelectionListener> listSelectionListeners = new ArrayList<ListSelectionListener>();
    private ListCellRenderer<T> cellRenderer;
    private ListSelectionModel selectionModel;
    private Integer visibleRowCount;
    private int layoutOrientation = 0;
    private int fixedCellHeight = -1;
    private int fixedCellWidth = -1;

    AbstractListBuilder(ListModel<T> listModel, Value<V> value) {
        super(value);
        this.listModel = Objects.requireNonNull(listModel);
    }

    @Override
    public final B visibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
        return (B)this;
    }

    @Override
    public final B layoutOrientation(int layoutOrientation) {
        this.layoutOrientation = layoutOrientation;
        return (B)this;
    }

    @Override
    public final B fixedCellHeight(int fixedCellHeight) {
        this.fixedCellHeight = fixedCellHeight;
        return (B)this;
    }

    @Override
    public final B fixedCellWidth(int fixedCellWidth) {
        this.fixedCellWidth = fixedCellWidth;
        return (B)this;
    }

    @Override
    public final B cellRenderer(ListCellRenderer<T> cellRenderer) {
        this.cellRenderer = Objects.requireNonNull(cellRenderer);
        return (B)this;
    }

    @Override
    public final B selectionModel(ListSelectionModel selectionModel) {
        this.selectionModel = Objects.requireNonNull(selectionModel);
        return (B)this;
    }

    @Override
    public final B listSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionListeners.add(Objects.requireNonNull(listSelectionListener));
        return (B)this;
    }

    protected final JList<T> createList() {
        JList<T> list = new JList<T>(this.listModel);
        if (this.cellRenderer != null) {
            list.setCellRenderer(this.cellRenderer);
        }
        if (this.selectionModel != null) {
            list.setSelectionModel(this.selectionModel);
        }
        this.listSelectionListeners.forEach(new AddListSelectionListener(list));
        if (this.visibleRowCount != null) {
            list.setVisibleRowCount(this.visibleRowCount);
        }
        list.setLayoutOrientation(this.layoutOrientation);
        list.setFixedCellHeight(this.fixedCellHeight);
        list.setFixedCellWidth(this.fixedCellWidth);
        return list;
    }
}

