/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.model.component.button.NullableToggleButtonModel;
import is.codion.swing.common.ui.key.KeyEvents;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class NullableCheckBox
extends JCheckBox {
    public NullableCheckBox() {
        this(new NullableToggleButtonModel());
    }

    public NullableCheckBox(NullableToggleButtonModel model) {
        this(model, null);
    }

    public NullableCheckBox(NullableToggleButtonModel model, String text) {
        this(model, text, null);
    }

    public NullableCheckBox(NullableToggleButtonModel model, String text, Icon icon) {
        super(text, icon);
        super.setModel((ButtonModel)Objects.requireNonNull(model, "model"));
        this.setIcon(new NullableIcon());
        this.addMouseListener(new NullableMouseListener());
        KeyEvents.builder(32).action(new NextStateAction(model)).enable(this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setIcon(new NullableIcon());
    }

    public final Boolean getState() {
        return this.getNullableModel().getState();
    }

    public final NullableToggleButtonModel getNullableModel() {
        return (NullableToggleButtonModel)this.getModel();
    }

    @Override
    public final void setModel(ButtonModel model) {
        if (this.getModel() instanceof NullableToggleButtonModel) {
            throw new UnsupportedOperationException("Setting the model of a NullableCheckBox after construction is not supported");
        }
        super.setModel(model);
    }

    @Override
    public final synchronized void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
    }

    @Override
    public final void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
    }

    private final class NullableIcon
    implements Icon {
        private final Icon icon = UIManager.getIcon("CheckBox.icon");
        private final boolean flatLaf = NullableCheckBox.this.getUI().getClass().getSimpleName().startsWith("Flat");

        private NullableIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            this.icon.paintIcon(component, graphics, x, y);
            if (NullableCheckBox.this.getNullableModel().getState() != null) {
                return;
            }
            double width = (double)this.getIconWidth() / 3.0;
            double height = (double)this.getIconHeight() / 3.0;
            double xCorner = (double)x + width + (this.flatLaf ? 0.5 : 0.0);
            double yCorner = (double)y + height - (this.flatLaf ? 0.25 : 0.0);
            Rectangle2D.Double rectangle = new Rectangle2D.Double(xCorner, yCorner, width, height);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(NullableCheckBox.this.isEnabled() ? NullableCheckBox.this.getForeground() : UIManager.getColor("CheckBoxMenuItem.disabledForeground"));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(rectangle);
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    private final class NullableMouseListener
    extends MouseAdapter {
        private NullableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (NullableCheckBox.this.isEnabled() && (e == null || this.notModified(e))) {
                NullableCheckBox.this.getNullableModel().nextState();
            }
        }

        private boolean notModified(MouseEvent e) {
            return !e.isAltDown() && !e.isControlDown() && !e.isShiftDown() && !e.isAltGraphDown() && !e.isMetaDown() && !e.isPopupTrigger();
        }
    }

    private static final class NextStateAction
    extends AbstractAction {
        private final NullableToggleButtonModel model;

        private NextStateAction(NullableToggleButtonModel model) {
            this.model = model;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.model.nextState();
        }
    }
}

