/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.button.NullableToggleButtonModel;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ToggleControl;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

abstract class AbstractButtonBuilder<T, C extends AbstractButton, B extends ButtonBuilder<T, C, B>>
extends AbstractComponentBuilder<T, C, B>
implements ButtonBuilder<T, C, B> {
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private String text;
    private int mnemonic;
    private boolean includeText = true;
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;
    private int horizontalTextPosition = 11;
    private int verticalTextPosition = 0;
    private boolean borderPainted = true;
    private boolean contentAreaFilled = true;
    private boolean focusPainted = true;
    private boolean rolloverEnabled = false;
    private Long multiClickThreshold;
    private Icon icon;
    private Icon pressedIcon;
    private Icon selectedIcon;
    private Icon rolloverIcon;
    private Icon rolloverSelectedIcon;
    private Icon disabledIcon;
    private Icon disabledSelectedIcon;
    private Integer iconTextGap;
    private Insets insets;
    private ButtonGroup buttonGroup;
    private boolean selected = false;
    private Action action;

    protected AbstractButtonBuilder(Value<T> linkedValue) {
        super(linkedValue);
    }

    @Override
    public final B text(String text) {
        this.text = text;
        return (B)this;
    }

    @Override
    public final B mnemonic(int mnemonic) {
        this.mnemonic = mnemonic;
        return (B)this;
    }

    @Override
    public final B includeText(boolean includeText) {
        this.includeText = includeText;
        return (B)this;
    }

    @Override
    public final B horizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return (B)this;
    }

    @Override
    public final B verticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return (B)this;
    }

    @Override
    public final B horizontalTextPosition(int horizontalTextPosition) {
        this.horizontalTextPosition = horizontalTextPosition;
        return (B)this;
    }

    @Override
    public final B verticalTextPosition(int verticalTextPosition) {
        this.verticalTextPosition = verticalTextPosition;
        return (B)this;
    }

    @Override
    public final B borderPainted(boolean borderPainted) {
        this.borderPainted = borderPainted;
        return (B)this;
    }

    @Override
    public final B contentAreaFilled(boolean contentAreaFilled) {
        this.contentAreaFilled = contentAreaFilled;
        return (B)this;
    }

    @Override
    public final B focusPainted(boolean focusPainted) {
        this.focusPainted = focusPainted;
        return (B)this;
    }

    @Override
    public final B rolloverEnabled(boolean rolloverEnabled) {
        this.rolloverEnabled = rolloverEnabled;
        return (B)this;
    }

    @Override
    public final B multiClickThreshold(long multiClickThreshold) {
        this.multiClickThreshold = multiClickThreshold;
        return (B)this;
    }

    @Override
    public final B icon(Icon icon) {
        this.icon = icon;
        return (B)this;
    }

    @Override
    public final B pressedIcon(Icon pressedIcon) {
        this.pressedIcon = pressedIcon;
        return (B)this;
    }

    @Override
    public final B selectedIcon(Icon selectedIcon) {
        this.selectedIcon = selectedIcon;
        return (B)this;
    }

    @Override
    public final B rolloverIcon(Icon rolloverIcon) {
        this.rolloverIcon = rolloverIcon;
        return (B)this;
    }

    @Override
    public final B rolloverSelectedIcon(Icon rolloverSelectedIcon) {
        this.rolloverSelectedIcon = rolloverSelectedIcon;
        return (B)this;
    }

    @Override
    public final B disabledIcon(Icon disabledIcon) {
        this.disabledIcon = disabledIcon;
        return (B)this;
    }

    @Override
    public final B disabledSelectedIcon(Icon disabledSelectedIcon) {
        this.disabledSelectedIcon = disabledSelectedIcon;
        return (B)this;
    }

    @Override
    public final B iconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
        return (B)this;
    }

    @Override
    public final B margin(Insets insets) {
        this.insets = Objects.requireNonNull(insets);
        return (B)this;
    }

    @Override
    public final B buttonGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = Objects.requireNonNull(buttonGroup);
        return (B)this;
    }

    @Override
    public final B selected(boolean selected) {
        this.selected = selected;
        return (B)this;
    }

    @Override
    public final B action(Action action) {
        this.action = action;
        return (B)this;
    }

    @Override
    public final B control(Control control) {
        return this.action(control);
    }

    @Override
    public final B control(Control.Builder<?, ?> controlBuilder) {
        return this.control((Control)Objects.requireNonNull(controlBuilder).build());
    }

    @Override
    public final B actionListener(ActionListener actionListener) {
        this.actionListeners.add(Objects.requireNonNull(actionListener));
        return (B)this;
    }

    @Override
    protected final C createComponent() {
        C button = this.createButton();
        if (this.action != null) {
            ((AbstractButton)button).setAction(this.action);
            ((JComponent)button).setBackground((Color)this.action.getValue("Background"));
            ((JComponent)button).setForeground((Color)this.action.getValue("Foreground"));
            Font actionFont = (Font)this.action.getValue("Font");
            if (actionFont != null) {
                ((JComponent)button).setFont(actionFont);
            }
            this.action.addPropertyChangeListener(new ActionPropertyChangeListener((AbstractButton)button));
        }
        this.actionListeners.forEach(new AddActionListener((AbstractButton)button));
        if (!this.includeText) {
            ((AbstractButton)button).setText(null);
            ((AbstractButton)button).setHideActionText(true);
        } else if (this.text != null) {
            ((AbstractButton)button).setText(this.text);
        }
        ((AbstractButton)button).setHorizontalAlignment(this.horizontalAlignment);
        ((AbstractButton)button).setVerticalAlignment(this.verticalAlignment);
        ((AbstractButton)button).setVerticalTextPosition(this.verticalTextPosition);
        ((AbstractButton)button).setHorizontalTextPosition(this.horizontalTextPosition);
        if (!this.borderPainted) {
            ((AbstractButton)button).setBorderPainted(false);
        }
        if (!this.contentAreaFilled) {
            ((AbstractButton)button).setContentAreaFilled(false);
        }
        if (!this.focusPainted) {
            ((AbstractButton)button).setFocusPainted(false);
        }
        if (this.rolloverEnabled) {
            ((AbstractButton)button).setRolloverEnabled(true);
        }
        if (this.multiClickThreshold != null) {
            ((AbstractButton)button).setMultiClickThreshhold(this.multiClickThreshold);
        }
        if (this.mnemonic != 0) {
            ((AbstractButton)button).setMnemonic(this.mnemonic);
        }
        if (this.icon != null) {
            ((AbstractButton)button).setIcon(this.icon);
        }
        if (this.pressedIcon != null) {
            ((AbstractButton)button).setPressedIcon(this.pressedIcon);
        }
        if (this.selectedIcon != null) {
            ((AbstractButton)button).setSelectedIcon(this.selectedIcon);
        }
        if (this.rolloverIcon != null) {
            ((AbstractButton)button).setRolloverIcon(this.rolloverIcon);
        }
        if (this.rolloverSelectedIcon != null) {
            ((AbstractButton)button).setRolloverSelectedIcon(this.rolloverSelectedIcon);
        }
        if (this.disabledIcon != null) {
            ((AbstractButton)button).setDisabledIcon(this.disabledIcon);
        }
        if (this.disabledSelectedIcon != null) {
            ((AbstractButton)button).setDisabledSelectedIcon(this.disabledSelectedIcon);
        }
        if (this.iconTextGap != null) {
            ((AbstractButton)button).setIconTextGap(this.iconTextGap);
        }
        if (this.insets != null) {
            ((AbstractButton)button).setMargin(this.insets);
        }
        if (this.buttonGroup != null) {
            this.buttonGroup.add((AbstractButton)button);
        }
        if (this.selected) {
            ((AbstractButton)button).setSelected(true);
        }
        return button;
    }

    protected abstract C createButton();

    static ButtonModel createButtonModel(ToggleControl toggleControl) {
        Object buttonModel = toggleControl.value().isNullable() ? new NullableToggleButtonModel((Boolean)toggleControl.value().get()) : AbstractButtonBuilder.createToggleButtonModel((Boolean)toggleControl.value().get());
        buttonModel.setEnabled((Boolean)toggleControl.enabled().get());
        toggleControl.enabled().addConsumer((Consumer)new SetEnabled((ButtonModel)buttonModel));
        new BooleanButtonModelValue((ButtonModel)buttonModel).link(toggleControl.value());
        return buttonModel;
    }

    private static JToggleButton.ToggleButtonModel createToggleButtonModel(boolean selected) {
        JToggleButton.ToggleButtonModel buttonModel = new JToggleButton.ToggleButtonModel();
        buttonModel.setSelected(selected);
        return buttonModel;
    }

    private static final class ActionPropertyChangeListener
    implements PropertyChangeListener {
        private final AbstractButton button;

        private ActionPropertyChangeListener(AbstractButton button) {
            this.button = Objects.requireNonNull(button);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "Background": {
                    this.button.setBackground((Color)evt.getNewValue());
                    break;
                }
                case "Foreground": {
                    this.button.setForeground((Color)evt.getNewValue());
                    break;
                }
                case "Font": {
                    if (evt.getNewValue() == null) break;
                    this.button.setFont((Font)evt.getNewValue());
                    break;
                }
                case "MnemonicKey": {
                    this.button.setMnemonic((Integer)evt.getNewValue());
                    break;
                }
            }
        }
    }

    private static final class AddActionListener
    implements Consumer<ActionListener> {
        private final AbstractButton button;

        private AddActionListener(AbstractButton button) {
            this.button = button;
        }

        @Override
        public void accept(ActionListener actionListener) {
            this.button.addActionListener(actionListener);
        }
    }

    private static final class SetEnabled
    implements Consumer<Boolean> {
        private final ButtonModel buttonModel;

        private SetEnabled(ButtonModel buttonModel) {
            this.buttonModel = buttonModel;
        }

        @Override
        public void accept(Boolean enabled) {
            this.buttonModel.setEnabled(enabled);
        }
    }

    private static final class BooleanButtonModelValue
    extends AbstractValue<Boolean> {
        private final ButtonModel buttonModel;

        private BooleanButtonModelValue(ButtonModel buttonModel) {
            this.buttonModel = buttonModel;
            buttonModel.addItemListener(itemEvent -> this.notifyListeners());
        }

        public Boolean get() {
            if (this.buttonModel instanceof NullableToggleButtonModel) {
                return ((NullableToggleButtonModel)this.buttonModel).getState();
            }
            return this.buttonModel.isSelected();
        }

        protected void setValue(Boolean value) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setModelValue(value);
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> this.setModelValue(value));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                catch (RuntimeException e) {
                    throw e;
                }
            }
        }

        private void setModelValue(Boolean value) {
            if (this.buttonModel instanceof NullableToggleButtonModel) {
                ((NullableToggleButtonModel)this.buttonModel).setState(value);
            } else {
                this.buttonModel.setSelected(value != null && value != false);
            }
        }
    }
}

