/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.model.UserPreferences;
import is.codion.common.state.State;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.DefaultOkCancelDialogBuilder;
import is.codion.swing.common.ui.dialog.LookAndFeelSelectionDialogBuilder;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.laf.LookAndFeelComboBox;
import is.codion.swing.common.ui.laf.LookAndFeelProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class DefaultLookAndFeelSelectionDialogBuilder
implements LookAndFeelSelectionDialogBuilder {
    private static final int PADDING = 10;
    private JComponent owner;
    private boolean enableOnSelection = (Boolean)LookAndFeelComboBox.ENABLE_ON_SELECTION.get();
    private String userPreferencePropertyName;

    DefaultLookAndFeelSelectionDialogBuilder() {
    }

    @Override
    public LookAndFeelSelectionDialogBuilder owner(JComponent owner) {
        this.owner = Objects.requireNonNull(owner);
        return this;
    }

    @Override
    public LookAndFeelSelectionDialogBuilder enableOnSelection(boolean enableOnSelection) {
        this.enableOnSelection = enableOnSelection;
        return this;
    }

    @Override
    public LookAndFeelSelectionDialogBuilder userPreferencePropertyName(String userPreferencePropertyName) {
        this.userPreferencePropertyName = userPreferencePropertyName;
        return this;
    }

    @Override
    public Control createControl() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(LookAndFeelProvider.class.getName());
        String caption = resourceBundle.getString("select_look_and_feel");
        return Control.builder(() -> this.selectLookAndFeel().ifPresent(provider -> {
            if (this.userPreferencePropertyName != null) {
                UserPreferences.setUserPreference((String)this.userPreferencePropertyName, (String)provider.lookAndFeelInfo().getClassName());
            }
        })).name(caption).build();
    }

    @Override
    public Optional<LookAndFeelProvider> selectLookAndFeel() {
        LookAndFeelComboBox lookAndFeelComboBox = LookAndFeelComboBox.lookAndFeelComboBox(this.enableOnSelection);
        JPanel basePanel = new JPanel(new BorderLayout());
        basePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        basePanel.add((Component)lookAndFeelComboBox, "Center");
        State okPressed = State.state();
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)new DefaultOkCancelDialogBuilder(basePanel).owner(this.owner)).title(ResourceBundle.getBundle(LookAndFeelProvider.class.getName()).getString("select_look_and_feel"))).onOk(() -> okPressed.set((Object)true)).show();
        if (((Boolean)okPressed.get()).booleanValue()) {
            lookAndFeelComboBox.enableSelected();
            return Optional.of(lookAndFeelComboBox.selectedLookAndFeel());
        }
        lookAndFeelComboBox.revert();
        return Optional.empty();
    }
}

