/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.i18n.Messages;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.text.DocumentAdapter;
import is.codion.swing.common.ui.component.button.CheckBoxMenuItemBuilder;
import is.codion.swing.common.ui.component.text.DefaultTextFieldBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.key.KeyEvents;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public final class SearchHighlighter {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(SearchHighlighter.class.getName());
    private final JTextComponent textComponent;
    private final Value<String> searchStringValue = Value.value((Object)"", (Object)"");
    private final State caseSensitiveState = State.state();
    private final Highlighter highlighter = new DefaultHighlighter();
    private final List<MatchPosition> searchTextPositions = new ArrayList<MatchPosition>();
    private final Value<Integer> currentSearchTextPositionIndex = Value.value();
    private final Value<Integer> selectedSearchTextPosition = Value.value();
    private Highlighter.HighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private Highlighter.HighlightPainter highlightSelectedPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.GREEN);

    private SearchHighlighter(JTextComponent textComponent) {
        this.textComponent = Objects.requireNonNull(textComponent);
        textComponent.setHighlighter(this.highlighter);
        this.bindEvents(textComponent);
    }

    public Value<String> searchString() {
        return this.searchStringValue;
    }

    public State caseSensitive() {
        return this.caseSensitiveState;
    }

    public void highlightColor(Color color) {
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Objects.requireNonNull(color));
        this.searchAndHighlightResults();
    }

    public void highlightSelectedColor(Color color) {
        this.highlightSelectedPainter = new DefaultHighlighter.DefaultHighlightPainter(Objects.requireNonNull(color));
        this.searchAndHighlightResults();
    }

    public JTextField createSearchField() {
        return (JTextField)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)new DefaultTextFieldBuilder(String.class, this.searchStringValue).selectAllOnFocusGained(true)).keyEvent(KeyEvents.builder(40).action(Control.control(this::nextSearchPosition)))).keyEvent(KeyEvents.builder(38).action(Control.control(this::previousSearchPosition)))).keyEvent(KeyEvents.builder(27).action(Control.control(this.textComponent::requestFocusInWindow)))).popupMenu(textField -> SearchHighlighter.createPopupMenu((ToggleControl)ToggleControl.builder(this.caseSensitiveState).name(MESSAGES.getString("case_sensitive")).build()))).hint(Messages.find() + "...").build();
    }

    public static SearchHighlighter searchHighlighter(JTextComponent textComponent) {
        return new SearchHighlighter(textComponent);
    }

    void nextSearchPosition() {
        if (!this.searchTextPositions.isEmpty()) {
            this.deselectCurrentSearchPosition();
            if (this.currentSearchTextPositionIndex.isNull() || this.currentSearchTextPositionIndex.isEqualTo((Object)(this.searchTextPositions.size() - 1))) {
                this.currentSearchTextPositionIndex.set((Object)0);
            } else {
                this.currentSearchTextPositionIndex.set((Object)((Integer)this.currentSearchTextPositionIndex.get() + 1));
            }
            this.selectCurrentSearchPosition();
        }
    }

    void previousSearchPosition() {
        if (!this.searchTextPositions.isEmpty()) {
            this.deselectCurrentSearchPosition();
            if (this.currentSearchTextPositionIndex.isNull() || this.currentSearchTextPositionIndex.isEqualTo((Object)0)) {
                this.currentSearchTextPositionIndex.set((Object)(this.searchTextPositions.size() - 1));
            } else {
                this.currentSearchTextPositionIndex.set((Object)((Integer)this.currentSearchTextPositionIndex.get() - 1));
            }
            this.selectCurrentSearchPosition();
        }
    }

    Integer selectedHighlightPosition() {
        return (Integer)this.selectedSearchTextPosition.get();
    }

    private void searchAndHighlightResults() {
        this.currentSearchTextPositionIndex.set(null);
        this.selectedSearchTextPosition.set(null);
        this.highlighter.removeAllHighlights();
        this.searchTextPositions.clear();
        if (!((String)this.searchStringValue.get()).isEmpty()) {
            Pattern pattern = Pattern.compile((String)this.searchStringValue.get(), (Boolean)this.caseSensitiveState.get() != false ? 0 : 2);
            try {
                Matcher matcher = pattern.matcher(this.textComponent.getDocument().getText(0, this.textComponent.getDocument().getLength()));
                int searchFrom = 0;
                while (matcher.find(searchFrom)) {
                    Object highlightTag = this.highlighter.addHighlight(matcher.start(), matcher.end(), this.highlightPainter);
                    this.searchTextPositions.add(new MatchPosition(matcher.start(), matcher.end(), highlightTag));
                    searchFrom = matcher.end();
                }
                this.nextSearchPosition();
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void selectCurrentSearchPosition() {
        MatchPosition matchPosition = this.searchTextPositions.get((Integer)this.currentSearchTextPositionIndex.get());
        this.selectedSearchTextPosition.set((Object)matchPosition.start);
        try {
            this.highlighter.removeHighlight(matchPosition.highlightTag);
            matchPosition.highlightTag = this.highlighter.addHighlight(matchPosition.start, matchPosition.end, this.highlightSelectedPainter);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void deselectCurrentSearchPosition() {
        if (this.currentSearchTextPositionIndex.isNotNull()) {
            MatchPosition matchPosition = this.searchTextPositions.get((Integer)this.currentSearchTextPositionIndex.get());
            try {
                this.highlighter.removeHighlight(matchPosition.highlightTag);
                matchPosition.highlightTag = this.highlighter.addHighlight(matchPosition.start, matchPosition.end, this.highlightPainter);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void bindEvents(JTextComponent textComponent) {
        this.searchStringValue.addListener(this::searchAndHighlightResults);
        this.caseSensitiveState.addListener(this::searchAndHighlightResults);
        textComponent.getDocument().addDocumentListener((DocumentListener)((DocumentAdapter)e -> this.searchAndHighlightResults()));
        this.selectedSearchTextPosition.addDataListener(selectedSearchPosition -> {
            if (selectedSearchPosition != null) {
                try {
                    textComponent.scrollRectToVisible(textComponent.modelToView((int)selectedSearchPosition));
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static JPopupMenu createPopupMenu(ToggleControl caseSensitiveControl) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add((JMenuItem)((CheckBoxMenuItemBuilder)CheckBoxMenuItemBuilder.builder().toggleControl(caseSensitiveControl)).build());
        return popupMenu;
    }

    private static final class MatchPosition {
        private final int start;
        private final int end;
        private Object highlightTag;

        private MatchPosition(int start, int end, Object highlightTag) {
            this.start = start;
            this.end = end;
            this.highlightTag = highlightTag;
        }
    }
}

