/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.NullOrEmpty;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.text.AbstractTextComponentBuilder;
import is.codion.swing.common.ui.component.text.CharacterFieldValue;
import is.codion.swing.common.ui.component.text.DefaultTextComponentValue;
import is.codion.swing.common.ui.component.text.HintTextField;
import is.codion.swing.common.ui.component.text.SizedDocument;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.dialog.SelectionDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;

class DefaultTextFieldBuilder<T, C extends JTextField, B extends TextFieldBuilder<T, C, B>>
extends AbstractTextComponentBuilder<T, C, B>
implements TextFieldBuilder<T, C, B> {
    private final Class<T> valueClass;
    private int columns = -1;
    private Action action;
    private ActionListener actionListener;
    private SelectionDialogBuilder.SingleSelector<T> selector;
    private Format format;
    private int horizontalAlignment = 10;
    private String hint;

    DefaultTextFieldBuilder(Class<T> valueClass, Value<T> linkedValue) {
        super(linkedValue);
        this.valueClass = Objects.requireNonNull(valueClass);
        if (valueClass.equals(Character.class)) {
            this.maximumLength(1);
        }
    }

    @Override
    public final B columns(int columns) {
        this.columns = columns;
        return (B)this;
    }

    @Override
    public final B action(Action action) {
        this.action = Objects.requireNonNull(action);
        return (B)((TextFieldBuilder)this.transferFocusOnEnter(false));
    }

    @Override
    public final B actionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
        return (B)((TextFieldBuilder)this.transferFocusOnEnter(false));
    }

    @Override
    public final B selector(SelectionDialogBuilder.SingleSelector<T> selector) {
        this.selector = Objects.requireNonNull(selector);
        return (B)this;
    }

    @Override
    public final B format(Format format) {
        this.format = format;
        return (B)this;
    }

    @Override
    public final B horizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return (B)this;
    }

    @Override
    public final B hint(String hint) {
        if (NullOrEmpty.nullOrEmpty((String)hint)) {
            throw new IllegalArgumentException("Hint is null or empty");
        }
        this.hint = hint;
        return (B)this;
    }

    @Override
    protected final C createTextComponent() {
        C textField = this.createTextField();
        if (this.columns != -1) {
            ((JTextField)textField).setColumns(this.columns);
        }
        ((JTextField)textField).setHorizontalAlignment(this.horizontalAlignment);
        if (this.action != null) {
            ((JTextField)textField).setAction(this.action);
        }
        if (this.actionListener != null) {
            ((JTextField)textField).addActionListener(this.actionListener);
        }
        if (this.selector != null) {
            this.setSelector(textField, this.selector);
        }
        if (this.hint != null && textField instanceof HintTextField) {
            ((HintTextField)textField).hint().set((Object)this.hint);
        }
        return textField;
    }

    protected C createTextField() {
        return (C)new HintTextField(SizedDocument.sizedDocument());
    }

    @Override
    protected ComponentValue<T, C> createComponentValue(C component) {
        Objects.requireNonNull(component);
        if (this.valueClass.equals(Character.class)) {
            return new CharacterFieldValue((JTextField)component, this.updateOn);
        }
        return new DefaultTextComponentValue(component, this.format, this.updateOn);
    }

    protected final Format format() {
        return this.format;
    }

    private void setSelector(C textField, SelectionDialogBuilder.SingleSelector<T> selector) {
        KeyEvents.builder(32).modifiers(128).action(new SelectionAction<T>((JTextField)textField, selector)).enable(new JComponent[]{textField});
    }

    private static final class SelectionAction<T>
    extends AbstractAction {
        private final JTextField textField;
        private final SelectionDialogBuilder.SingleSelector<T> selector;

        private SelectionAction(JTextField textField, SelectionDialogBuilder.SingleSelector<T> selector) {
            super("DefaultTextFieldBuilder.SelectionAction");
            this.textField = textField;
            this.selector = selector;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.selector.select(this.textField).ifPresent(value -> this.textField.setText(value.toString()));
        }
    }
}

