/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.swing.common.ui.component.text.MaskFormatterBuilder;
import java.text.ParseException;
import java.util.Objects;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

final class DefaultMaskFormatter
extends MaskFormatter {
    private final boolean emptyStringToNullValue;
    private final boolean invalidStringToNullValue;

    private DefaultMaskFormatter(DefaultMaskFormatterBuilder builder) throws ParseException {
        super(builder.mask);
        this.emptyStringToNullValue = builder.emptyStringToNullValue;
        this.invalidStringToNullValue = builder.invalidStringToNullValue;
        this.setValueContainsLiteralCharacters(builder.valueContainsLiteralCharacters);
        this.setPlaceholder(builder.placeholder);
        this.setPlaceholderCharacter(builder.placeholderCharacter);
        this.setAllowsInvalid(builder.allowsInvalid);
        this.setCommitsOnValidEdit(builder.commitsOnValidEdit);
        this.setValidCharacters(builder.validCharacters);
        this.setInvalidCharacters(builder.invalidCharacters);
        this.setOverwriteMode(builder.overwriteMode);
    }

    @Override
    public Object stringToValue(String value) throws ParseException {
        if (this.emptyStringToNullValue && Objects.equals(value, this.valueToString(""))) {
            return null;
        }
        try {
            return super.stringToValue(value);
        }
        catch (ParseException e) {
            if (this.invalidStringToNullValue) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void install(JFormattedTextField field) {
        int previousLength = field.getDocument().getLength();
        int currentCaretPosition = field.getCaretPosition();
        int currentSelectionStart = field.getSelectionStart();
        int currentSelectionEnd = field.getSelectionEnd();
        super.install(field);
        if (previousLength == field.getDocument().getLength()) {
            if (currentSelectionEnd - currentSelectionStart > 0) {
                field.setCaretPosition(currentSelectionStart);
                field.moveCaretPosition(currentSelectionEnd);
            } else {
                field.setCaretPosition(currentCaretPosition);
            }
        }
    }

    static final class DefaultMaskFormatterBuilder
    implements MaskFormatterBuilder {
        private String mask;
        private boolean valueContainsLiteralCharacters = true;
        private String placeholder;
        private char placeholderCharacter = (char)32;
        private boolean allowsInvalid = false;
        private boolean commitsOnValidEdit = true;
        private String validCharacters;
        private String invalidCharacters;
        private boolean overwriteMode = true;
        private boolean emptyStringToNullValue = true;
        private boolean invalidStringToNullValue = false;

        DefaultMaskFormatterBuilder() {
        }

        @Override
        public MaskFormatterBuilder mask(String mask) {
            this.mask = Objects.requireNonNull(mask);
            return this;
        }

        @Override
        public MaskFormatterBuilder valueContainsLiteralCharacters(boolean valueContainsLiteralCharacters) {
            this.valueContainsLiteralCharacters = valueContainsLiteralCharacters;
            return this;
        }

        @Override
        public MaskFormatterBuilder placeholder(String placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder);
            return this;
        }

        @Override
        public MaskFormatterBuilder placeholderCharacter(char placeholderCharacter) {
            this.placeholderCharacter = placeholderCharacter;
            return this;
        }

        @Override
        public MaskFormatterBuilder allowsInvalid(boolean allowsInvalid) {
            this.allowsInvalid = allowsInvalid;
            return this;
        }

        @Override
        public MaskFormatterBuilder commitsOnValidEdit(boolean commitsOnValidEdit) {
            this.commitsOnValidEdit = commitsOnValidEdit;
            return this;
        }

        @Override
        public MaskFormatterBuilder validCharacters(String validCharacters) {
            this.validCharacters = Objects.requireNonNull(validCharacters);
            return this;
        }

        @Override
        public MaskFormatterBuilder invalidCharacters(String invalidCharacters) {
            this.invalidCharacters = Objects.requireNonNull(invalidCharacters);
            return this;
        }

        @Override
        public MaskFormatterBuilder overwriteMode(boolean overwriteMode) {
            this.overwriteMode = overwriteMode;
            return this;
        }

        @Override
        public MaskFormatterBuilder emptyStringToNullValue(boolean emptyStringToNullValue) {
            this.emptyStringToNullValue = emptyStringToNullValue;
            return this;
        }

        @Override
        public MaskFormatterBuilder invalidStringToNullValue(boolean invalidStringToNullValue) {
            this.invalidStringToNullValue = invalidStringToNullValue;
            return this;
        }

        @Override
        public MaskFormatter build() throws ParseException {
            return new DefaultMaskFormatter(this);
        }
    }
}

