/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.splitpane;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.splitpane.SplitPaneBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

final class DefaultSplitPaneBuilder
extends AbstractComponentBuilder<Void, JSplitPane, SplitPaneBuilder>
implements SplitPaneBuilder {
    private int orientation = 1;
    private boolean oneTouchExpandable = false;
    private JComponent leftTopComponent;
    private JComponent rightBottomComponent;
    private double resizeWeight;
    private boolean continuousLayout;
    private int dividerSize;

    DefaultSplitPaneBuilder() {
    }

    @Override
    public SplitPaneBuilder orientation(int orientation) {
        this.orientation = orientation;
        return this;
    }

    @Override
    public SplitPaneBuilder oneTouchExpandable(boolean oneTouchExpandable) {
        this.oneTouchExpandable = oneTouchExpandable;
        return this;
    }

    @Override
    public SplitPaneBuilder leftComponent(JComponent leftComponent) {
        this.leftTopComponent = leftComponent;
        return this;
    }

    @Override
    public SplitPaneBuilder rightComponent(JComponent rightComponent) {
        this.rightBottomComponent = rightComponent;
        return this;
    }

    @Override
    public SplitPaneBuilder topComponent(JComponent topComponent) {
        this.leftTopComponent = topComponent;
        return this;
    }

    @Override
    public SplitPaneBuilder bottomComponent(JComponent bottomComponent) {
        this.rightBottomComponent = bottomComponent;
        return this;
    }

    @Override
    public SplitPaneBuilder resizeWeight(double resizeWeight) {
        this.resizeWeight = resizeWeight;
        return this;
    }

    @Override
    public SplitPaneBuilder continuousLayout(boolean continuousLayout) {
        this.continuousLayout = continuousLayout;
        return this;
    }

    @Override
    public SplitPaneBuilder dividerSize(int dividerSize) {
        this.dividerSize = dividerSize;
        return this;
    }

    @Override
    protected JSplitPane createComponent() {
        JSplitPane splitPane = new JSplitPane(this.orientation);
        splitPane.setLeftComponent(this.leftTopComponent);
        splitPane.setRightComponent(this.rightBottomComponent);
        splitPane.setResizeWeight(this.resizeWeight);
        splitPane.setOneTouchExpandable(this.oneTouchExpandable);
        splitPane.setContinuousLayout(this.continuousLayout);
        if (this.dividerSize > 0) {
            splitPane.setDividerSize(this.dividerSize);
        }
        return splitPane;
    }

    @Override
    protected ComponentValue<Void, JSplitPane> createComponentValue(JSplitPane component) {
        throw new UnsupportedOperationException("A ComponentValue can not be based on a JSplitPane");
    }

    @Override
    protected void setInitialValue(JSplitPane component, Void initialValue) {
    }
}

