/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;

public abstract class FileTransferHandler
extends TransferHandler {
    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        return FileTransferHandler.fileDataFlavor(transferSupport);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        List<File> files = FileTransferHandler.transferFiles(transferSupport);
        if (files.isEmpty()) {
            return false;
        }
        return this.importFiles(transferSupport.getComponent(), files);
    }

    public static void addSingleFileDragAndDropSupport(final JTextComponent textComponent) {
        Objects.requireNonNull(textComponent, "textComponent");
        textComponent.setDragEnabled(true);
        textComponent.setTransferHandler(new FileTransferHandler(){

            @Override
            protected boolean importFiles(Component component, List<File> files) {
                textComponent.setText(files.get(0).getAbsolutePath());
                textComponent.requestFocusInWindow();
                return true;
            }
        });
    }

    public static boolean fileDataFlavor(TransferHandler.TransferSupport transferSupport) {
        Objects.requireNonNull(transferSupport, "transferSupport");
        try {
            DataFlavor nixFileDataFlavor = FileTransferHandler.nixFileDataFlavor();
            return Arrays.stream(transferSupport.getDataFlavors()).anyMatch(flavor -> flavor.isFlavorJavaFileListType() || flavor.equals(nixFileDataFlavor));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<File> transferFiles(TransferHandler.TransferSupport transferSupport) {
        Objects.requireNonNull(transferSupport, "transferSupport");
        try {
            for (DataFlavor flavor : transferSupport.getDataFlavors()) {
                if (!flavor.isFlavorJavaFileListType()) continue;
                List files = (List)transferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                return files.isEmpty() ? Collections.emptyList() : files;
            }
            ArrayList<File> files = new ArrayList<File>();
            DataFlavor nixFileDataFlavor = FileTransferHandler.nixFileDataFlavor();
            String data = (String)transferSupport.getTransferable().getTransferData(nixFileDataFlavor);
            StringTokenizer st = new StringTokenizer(data, "\r\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("#") || token.isEmpty()) continue;
                files.add(new File(new URI(token)));
            }
            return files;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract boolean importFiles(Component var1, List<File> var2);

    private static DataFlavor nixFileDataFlavor() throws ClassNotFoundException {
        return new DataFlavor("text/uri-list;class=java.lang.String");
    }
}

