/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.combobox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

final class CopyEditorActionsListener
implements PropertyChangeListener {
    private JComponent previousEditor;

    CopyEditorActionsListener() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        ComboBoxEditor newEditor;
        ComboBoxEditor oldEditor = (ComboBoxEditor)event.getOldValue();
        if (oldEditor != null) {
            this.previousEditor = (JComponent)oldEditor.getEditorComponent();
        }
        if ((newEditor = (ComboBoxEditor)event.getNewValue()) != null && this.previousEditor != null) {
            CopyEditorActionsListener.copyActions(this.previousEditor, (JComponent)newEditor.getEditorComponent());
            this.previousEditor = null;
        }
    }

    private static void copyActions(JComponent previousComponent, JComponent newComponent) {
        ActionMap previousActionMap = previousComponent.getActionMap();
        ActionMap newActionMap = newComponent.getActionMap();
        Arrays.stream(previousActionMap.allKeys()).forEach(key -> newActionMap.put(key, previousActionMap.get(key)));
        InputMap previousInputMap = previousComponent.getInputMap();
        InputMap newInputMap = newComponent.getInputMap();
        Arrays.stream(previousInputMap.allKeys()).forEach(key -> newInputMap.put((KeyStroke)key, previousInputMap.get((KeyStroke)key)));
    }
}

