/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.calendar;

import is.codion.common.item.Item;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.label.LabelBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.spinner.ItemSpinnerBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public final class CalendarPanel
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(CalendarPanel.class.getName());
    public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class, CalendarPanel::defaultKeyStroke);
    private static final Set<Class<? extends Temporal>> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(LocalDate.class, LocalDateTime.class)));
    private static final int YEAR_COLUMNS = 4;
    private static final int TIME_COLUMNS = 2;
    private static final int DAYS_IN_WEEK = 7;
    private static final int MAX_DAYS_IN_MONTH = 31;
    private static final int MAX_DAY_FILLERS = 14;
    private static final int DAY_GRID_ROWS = 6;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL);
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    private final Value<LocalDate> localDateValue;
    private final Value<LocalDateTime> localDateTimeValue;
    private final Value<Integer> yearValue;
    private final Value<Month> monthValue;
    private final Value<Integer> dayValue;
    private final Value<Integer> hourValue;
    private final Value<Integer> minuteValue;
    private final State todaySelected;
    private final Map<Integer, JToggleButton> dayButtons;
    private final Map<Integer, State> dayStates;
    private final JPanel dayGridPanel;
    private final List<JLabel> dayFillLabels;
    private final JLabel formattedDateLabel;
    private final boolean includeTime;
    private final boolean includeTodayButton;

    CalendarPanel(DefaultBuilder builder) {
        this.includeTime = builder.includeTime;
        this.includeTodayButton = builder.includeTodayButton;
        LocalDateTime dateTime = builder.initialValue == null ? LocalDateTime.now() : builder.initialValue;
        this.yearValue = Value.value((Object)dateTime.getYear(), (Object)dateTime.getYear());
        this.monthValue = Value.value((Object)dateTime.getMonth(), (Object)dateTime.getMonth());
        this.dayValue = Value.value((Object)dateTime.getDayOfMonth(), (Object)dateTime.getDayOfMonth());
        if (this.includeTime) {
            this.hourValue = Value.value((Object)dateTime.getHour(), (Object)dateTime.getHour());
            this.minuteValue = Value.value((Object)dateTime.getMinute(), (Object)dateTime.getMinute());
        } else {
            this.hourValue = Value.value((Object)0, (Object)0);
            this.minuteValue = Value.value((Object)0, (Object)0);
        }
        this.localDateValue = Value.value((Object)this.createLocalDateTime().toLocalDate());
        this.localDateTimeValue = Value.value((Object)this.createLocalDateTime());
        this.todaySelected = State.state((boolean)this.todaySelected());
        this.dayStates = this.createDayStates();
        this.dayButtons = this.createDayButtons();
        this.dayFillLabels = IntStream.rangeClosed(0, 15).mapToObj(counter -> new JLabel()).collect(Collectors.toList());
        this.dayGridPanel = new JPanel(new GridLayout(6, 7));
        this.formattedDateLabel = new JLabel("", 0);
        this.formattedDateLabel.setBorder(Borders.emptyBorder());
        this.initializeUI();
        this.addKeyEvents(builder.keyboardShortcuts);
        this.updateFormattedDate();
        this.bindEvents();
    }

    public void setLocalDate(LocalDate date) {
        this.setLocalDateTime(Objects.requireNonNull(date).atStartOfDay());
    }

    public LocalDate getLocalDate() {
        return LocalDate.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get(), (int)((Integer)this.dayValue.get()));
    }

    public void setLocalDateTime(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime);
        if (this.includeTime) {
            this.setYearMonthDayHourMinute(dateTime);
        } else {
            this.setYearMonthDay(dateTime.toLocalDate());
        }
    }

    public LocalDateTime getLocalDateTime() {
        return (LocalDateTime)this.localDateTimeValue.get();
    }

    public void requestCurrentDayButtonFocus() {
        this.dayButtons.get(this.dayValue.get()).requestFocusInWindow();
    }

    public ValueObserver<LocalDate> localDateValue() {
        return this.localDateValue.observer();
    }

    public ValueObserver<LocalDateTime> localDateTimeValue() {
        return this.localDateTimeValue.observer();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Collection<Class<? extends Temporal>> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    void previousMonth() {
        this.subtractOne(ChronoUnit.MONTHS);
    }

    void nextMonth() {
        this.addOne(ChronoUnit.MONTHS);
    }

    void previousYear() {
        this.subtractOne(ChronoUnit.YEARS);
    }

    void nextYear() {
        this.addOne(ChronoUnit.YEARS);
    }

    void previousWeek() {
        this.subtractOne(ChronoUnit.WEEKS);
    }

    void nextWeek() {
        this.addOne(ChronoUnit.WEEKS);
    }

    void previousDay() {
        this.subtractOne(ChronoUnit.DAYS);
    }

    void nextDay() {
        this.addOne(ChronoUnit.DAYS);
    }

    void previousHour() {
        this.subtractOne(ChronoUnit.HOURS);
    }

    void nextHour() {
        this.addOne(ChronoUnit.HOURS);
    }

    void previousMinute() {
        this.subtractOne(ChronoUnit.MINUTES);
    }

    void nextMinute() {
        this.addOne(ChronoUnit.MINUTES);
    }

    private void subtractOne(ChronoUnit unit) {
        boolean dayPanelHasFocus = this.dayPanelHasFocus();
        if (unit.isDateBased()) {
            this.setYearMonthDay(this.getLocalDate().minus(1L, unit));
        } else {
            this.setYearMonthDayHourMinute(this.getLocalDateTime().minus(1L, unit));
        }
        if (dayPanelHasFocus) {
            this.requestCurrentDayButtonFocus();
        }
    }

    private void addOne(ChronoUnit unit) {
        boolean dayPanelHasFocus = this.dayPanelHasFocus();
        if (unit.isDateBased()) {
            this.setYearMonthDay(this.getLocalDate().plus(1L, unit));
        } else {
            this.setYearMonthDayHourMinute(this.getLocalDateTime().plus(1L, unit));
        }
        if (dayPanelHasFocus) {
            this.requestCurrentDayButtonFocus();
        }
    }

    private Map<Integer, State> createDayStates() {
        Map<Integer, State> states = IntStream.rangeClosed(1, 31).boxed().collect(Collectors.toMap(Integer::valueOf, this::createDayState));
        State.group(states.values());
        return states;
    }

    private State createDayState(int dayOfMonth) {
        State dayState = State.state(((Integer)this.dayValue.get() == dayOfMonth ? 1 : 0) != 0);
        dayState.addDataListener(selected -> {
            if (selected.booleanValue()) {
                this.dayValue.set((Object)dayOfMonth);
            }
        });
        return dayState;
    }

    private Map<Integer, JToggleButton> createDayButtons() {
        Insets margin = new Insets(0, 0, 0, 0);
        return this.dayStates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (JToggleButton)((ToggleButtonBuilder)((ToggleButtonBuilder)Components.toggleButton((Value<Boolean>)((Value)entry.getValue())).text(Integer.toString((Integer)entry.getKey()))).margin(margin)).build()));
    }

    private void initializeUI() {
        this.setLayout(Layouts.borderLayout());
        this.setBorder(Borders.emptyBorder());
        this.add((Component)this.createNorthPanel(), "North");
        this.add((Component)this.createDayPanel(), "Center");
        this.layoutDayPanel();
    }

    private JPanel createNorthPanel() {
        return (JPanel)Components.borderLayoutPanel().northComponent((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent(this.formattedDateLabel).border(BorderFactory.createTitledBorder(""))).build()).centerComponent((JComponent)((PanelBuilder)Components.flowLayoutPanel(1).add(this.createYearMonthHourMinutePanel()).border(BorderFactory.createTitledBorder(""))).build()).build();
    }

    private JPanel createYearMonthHourMinutePanel() {
        JSpinner yearSpinner = this.createYearSpinner();
        JSpinner monthSpinner = this.createMonthSpinner(yearSpinner);
        JSpinner hourSpinner = this.createHourSpinner();
        JSpinner minuteSpinner = this.createMinuteSpinner();
        PanelBuilder yearMonthHourMinutePanel = Components.flexibleGridLayoutPanel(1, 0).add(monthSpinner).add(yearSpinner);
        if (this.includeTime) {
            yearMonthHourMinutePanel.addAll(hourSpinner, new JLabel(":", 0), minuteSpinner);
        }
        if (this.includeTodayButton) {
            yearMonthHourMinutePanel.add(this.createSelectTodayButton());
        }
        return (JPanel)yearMonthHourMinutePanel.build();
    }

    private JButton createSelectTodayButton() {
        return (JButton)((ButtonBuilder)Components.button(Control.control(this::selectToday)).text(MESSAGES.getString("today")).mnemonic(MESSAGES.getString("today_mnemonic").charAt(0)).enabled(this.todaySelected.not())).build();
    }

    private JPanel createDayPanel() {
        return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().northComponent(CalendarPanel.createDayHeaderPanel()).centerComponent(this.dayGridPanel).border(BorderFactory.createTitledBorder(""))).build();
    }

    private void layoutDayPanel() {
        boolean dayPanelHasFocus = this.dayPanelHasFocus();
        if (dayPanelHasFocus) {
            this.dayGridPanel.requestFocusInWindow();
        }
        this.dayGridPanel.removeAll();
        int firstDayOfMonth = LocalDate.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get(), 1).getDayOfWeek().getValue();
        int fieldCount = 0;
        int fillerCount = 0;
        for (int i = 1; i < firstDayOfMonth; ++i) {
            this.dayGridPanel.add(this.dayFillLabels.get(fillerCount++));
            ++fieldCount;
        }
        YearMonth yearMonth = YearMonth.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get());
        for (int dayOfMonth = 1; dayOfMonth <= yearMonth.lengthOfMonth(); ++dayOfMonth) {
            this.dayGridPanel.add(this.dayButtons.get(dayOfMonth));
            ++fieldCount;
        }
        while (fieldCount++ < 42) {
            this.dayGridPanel.add(this.dayFillLabels.get(fillerCount++));
        }
        this.validate();
        this.repaint();
        if (dayPanelHasFocus) {
            this.requestCurrentDayButtonFocus();
        }
    }

    private boolean dayPanelHasFocus() {
        return this.dayGridPanel.isAncestorOf(FocusManager.getCurrentManager().getFocusOwner());
    }

    private void setYearMonthDay(LocalDate localDate) {
        this.yearValue.set((Object)localDate.getYear());
        this.monthValue.set((Object)localDate.getMonth());
        this.dayValue.set((Object)localDate.getDayOfMonth());
    }

    private void setYearMonthDayHourMinute(LocalDateTime localDateTime) {
        this.setYearMonthDay(localDateTime.toLocalDate());
        this.hourValue.set((Object)localDateTime.getHour());
        this.minuteValue.set((Object)localDateTime.getMinute());
    }

    private LocalDateTime createLocalDateTime() {
        return LocalDateTime.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get(), (int)((Integer)this.dayValue.get()), (int)((Integer)this.hourValue.get()), (int)((Integer)this.minuteValue.get()));
    }

    private void updateDateTime() {
        YearMonth yearMonth = YearMonth.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get());
        this.dayStates.get((Integer)this.dayValue.get() > yearMonth.lengthOfMonth() ? yearMonth.lengthOfMonth() : ((Integer)this.dayValue.get()).intValue()).set((Object)true);
        LocalDateTime localDateTime = this.createLocalDateTime();
        this.localDateValue.set((Object)localDateTime.toLocalDate());
        this.localDateTimeValue.set((Object)localDateTime);
        this.todaySelected.set((Object)this.todaySelected());
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateFormattedDate();
        } else {
            SwingUtilities.invokeLater(this::updateFormattedDate);
        }
    }

    private boolean todaySelected() {
        return this.getLocalDate().equals(LocalDate.now());
    }

    private void selectToday() {
        this.dayGridPanel.requestFocusInWindow();
        LocalDate now = LocalDate.now();
        this.setLocalDateTime(this.getLocalDateTime().withYear(now.getYear()).withMonth(now.getMonthValue()).withDayOfMonth(now.getDayOfMonth()));
        this.requestCurrentDayButtonFocus();
    }

    private void updateFormattedDate() {
        this.formattedDateLabel.setText(this.dateFormatter.format(this.getLocalDateTime()) + (String)(this.includeTime ? ", " + this.timeFormatter.format(this.getLocalDateTime()) : ""));
    }

    private void addKeyEvents(KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts) {
        KeyEvents.Builder keyEvent = KeyEvents.builder().condition(1);
        keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.PREVIOUS_YEAR).get()).action(Control.control(this::previousYear)).enable(this);
        keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.NEXT_YEAR).get()).action(Control.control(this::nextYear)).enable(this);
        keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.PREVIOUS_MONTH).get()).action(Control.control(this::previousMonth)).enable(this);
        keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.NEXT_MONTH).get()).action(Control.control(this::nextMonth)).enable(this);
        keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.PREVIOUS_WEEK).get()).action(Control.control(this::previousWeek)).enable(this);
        keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.NEXT_WEEK).get()).action(Control.control(this::nextWeek)).enable(this);
        keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.PREVIOUS_DAY).get()).action(Control.control(this::previousDay)).enable(this);
        keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.NEXT_DAY).get()).action(Control.control(this::nextDay)).enable(this);
        if (this.includeTime) {
            keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.PREVIOUS_HOUR).get()).action(Control.control(this::previousHour)).enable(this);
            keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.NEXT_HOUR).get()).action(Control.control(this::nextHour)).enable(this);
            keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.PREVIOUS_MINUTE).get()).action(Control.control(this::previousMinute)).enable(this);
            keyEvent.keyStroke((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.NEXT_MINUTE).get()).action(Control.control(this::nextMinute)).enable(this);
        }
    }

    private void bindEvents() {
        this.yearValue.addListener(this::updateDateTime);
        this.monthValue.addListener(this::updateDateTime);
        this.dayValue.addListener(this::updateDateTime);
        this.hourValue.addListener(this::updateDateTime);
        this.minuteValue.addListener(this::updateDateTime);
        LayoutDayPanelListener layoutDayPanelListener = new LayoutDayPanelListener();
        this.yearValue.addListener((Runnable)layoutDayPanelListener);
        this.monthValue.addListener((Runnable)layoutDayPanelListener);
    }

    private JSpinner createYearSpinner() {
        return (JSpinner)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(new SpinnerNumberModel(0, -9999, 9999, 1), this.yearValue).horizontalAlignment(0)).columns(4)).editable(false)).groupingUsed(false).onBuild(CalendarPanel::removeCtrlLeftRightArrowKeyEvents)).build();
    }

    private JSpinner createMonthSpinner(JSpinner yearSpinner) {
        List<Item<Month>> monthItems = CalendarPanel.createMonthItems();
        JSpinner monthSpinner = (JSpinner)((ItemSpinnerBuilder)((ItemSpinnerBuilder)((ItemSpinnerBuilder)Components.itemSpinner(new SpinnerListModel(monthItems), this.monthValue).horizontalAlignment(0)).editable(false)).onBuild(CalendarPanel::removeCtrlLeftRightArrowKeyEvents)).build();
        JFormattedTextField monthTextField = ((JSpinner.DefaultEditor)monthSpinner.getEditor()).getTextField();
        monthTextField.setFont(((JSpinner.DefaultEditor)yearSpinner.getEditor()).getTextField().getFont());
        monthItems.stream().mapToInt(item -> item.caption().length()).max().ifPresent(monthTextField::setColumns);
        return monthSpinner;
    }

    private JSpinner createHourSpinner() {
        return (JSpinner)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(new SpinnerNumberModel(0, 0, 23, 1), this.hourValue).horizontalAlignment(0)).columns(2)).editable(false)).decimalFormatPattern("00").onBuild(CalendarPanel::removeCtrlLeftRightArrowKeyEvents)).build();
    }

    private JSpinner createMinuteSpinner() {
        return (JSpinner)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(new SpinnerNumberModel(0, 0, 59, 1), this.minuteValue).horizontalAlignment(0)).columns(2)).editable(false)).decimalFormatPattern("00").onBuild(CalendarPanel::removeCtrlLeftRightArrowKeyEvents)).build();
    }

    private static JSpinner removeCtrlLeftRightArrowKeyEvents(JSpinner spinner) {
        InputMap inputMap = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().getInputMap(0);
        inputMap.put(KeyboardShortcuts.keyStroke(37, 128), "none");
        inputMap.put(KeyboardShortcuts.keyStroke(39, 128), "none");
        inputMap.put(KeyboardShortcuts.keyStroke(37, 64), "none");
        inputMap.put(KeyboardShortcuts.keyStroke(39, 64), "none");
        return spinner;
    }

    private static JPanel createDayHeaderPanel() {
        return (JPanel)Components.panel(new GridLayout(1, 7)).add(CalendarPanel.createDayLabel(DayOfWeek.MONDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.TUESDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.WEDNESDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.THURSDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.FRIDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.SATURDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.SUNDAY)).build();
    }

    private static JLabel createDayLabel(DayOfWeek dayOfWeek) {
        return (JLabel)((LabelBuilder)Components.label(dayOfWeek.getDisplayName(TextStyle.SHORT, Locale.getDefault())).horizontalAlignment(0).border(Borders.emptyBorder())).build();
    }

    private static List<Item<Month>> createMonthItems() {
        return Arrays.stream(Month.values()).map(month -> Item.item((Object)month, (String)month.getDisplayName(TextStyle.SHORT, Locale.getDefault()))).collect(Collectors.toList());
    }

    private static KeyStroke defaultKeyStroke(KeyboardShortcut shortcut) {
        switch (shortcut) {
            case PREVIOUS_YEAR: {
                return KeyboardShortcuts.keyStroke(40, 128);
            }
            case NEXT_YEAR: {
                return KeyboardShortcuts.keyStroke(38, 128);
            }
            case PREVIOUS_MONTH: {
                return KeyboardShortcuts.keyStroke(40, 64);
            }
            case NEXT_MONTH: {
                return KeyboardShortcuts.keyStroke(38, 64);
            }
            case PREVIOUS_WEEK: {
                return KeyboardShortcuts.keyStroke(38, 512);
            }
            case NEXT_WEEK: {
                return KeyboardShortcuts.keyStroke(40, 512);
            }
            case PREVIOUS_DAY: {
                return KeyboardShortcuts.keyStroke(37, 512);
            }
            case NEXT_DAY: {
                return KeyboardShortcuts.keyStroke(39, 512);
            }
            case PREVIOUS_HOUR: {
                return KeyboardShortcuts.keyStroke(40, 576);
            }
            case NEXT_HOUR: {
                return KeyboardShortcuts.keyStroke(38, 576);
            }
            case PREVIOUS_MINUTE: {
                return KeyboardShortcuts.keyStroke(40, 640);
            }
            case NEXT_MINUTE: {
                return KeyboardShortcuts.keyStroke(38, 640);
            }
        }
        throw new IllegalArgumentException();
    }

    private static final class DefaultBuilder
    implements Builder {
        private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts = KEYBOARD_SHORTCUTS.copy();
        private LocalDateTime initialValue;
        private boolean includeTime = false;
        private boolean includeTodayButton = false;

        private DefaultBuilder() {
        }

        @Override
        public Builder initialValue(LocalDate initialValue) {
            this.initialValue = initialValue == null ? LocalDate.now().atStartOfDay() : initialValue.atStartOfDay();
            return this.includeTime(false);
        }

        @Override
        public Builder initialValue(LocalDateTime initialValue) {
            this.initialValue = initialValue == null ? LocalDateTime.now() : initialValue;
            return this.includeTime(true);
        }

        @Override
        public Builder includeTime(boolean includeTime) {
            this.includeTime = includeTime;
            return this;
        }

        @Override
        public Builder includeTodayButton(boolean includeTodayButton) {
            this.includeTodayButton = includeTodayButton;
            return this;
        }

        @Override
        public Builder keyStroke(KeyboardShortcut keyboardShortcut, KeyStroke keyStroke) {
            this.keyboardShortcuts.keyStroke(keyboardShortcut).set((Object)keyStroke);
            return this;
        }

        @Override
        public CalendarPanel build() {
            return new CalendarPanel(this);
        }
    }

    public static enum KeyboardShortcut {
        PREVIOUS_YEAR,
        NEXT_YEAR,
        PREVIOUS_MONTH,
        NEXT_MONTH,
        PREVIOUS_WEEK,
        NEXT_WEEK,
        PREVIOUS_DAY,
        NEXT_DAY,
        PREVIOUS_HOUR,
        NEXT_HOUR,
        PREVIOUS_MINUTE,
        NEXT_MINUTE;

    }

    private final class LayoutDayPanelListener
    implements Runnable {
        private LayoutDayPanelListener() {
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                CalendarPanel.this.layoutDayPanel();
            } else {
                SwingUtilities.invokeLater(CalendarPanel.this::layoutDayPanel);
            }
        }
    }

    public static interface Builder {
        public Builder initialValue(LocalDate var1);

        public Builder initialValue(LocalDateTime var1);

        public Builder includeTime(boolean var1);

        public Builder includeTodayButton(boolean var1);

        public Builder keyStroke(KeyboardShortcut var1, KeyStroke var2);

        public CalendarPanel build();
    }
}

