/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.key;

import is.codion.swing.common.ui.key.KeyEvents;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public final class TransferFocusOnEnter {
    private TransferFocusOnEnter() {
    }

    public static <T extends JComponent> T enable(T component) {
        TransferFocusOnEnter.forwardBuilder(component).enable(component);
        TransferFocusOnEnter.backwardsBuilder().enable(component);
        return component;
    }

    public static <T extends JComponent> T disable(T component) {
        TransferFocusOnEnter.forwardBuilder(component).disable(component);
        TransferFocusOnEnter.backwardsBuilder().disable(component);
        return component;
    }

    public static Action forwardAction() {
        return new TransferFocusAction(false);
    }

    public static Action backwardAction() {
        return new TransferFocusAction(true);
    }

    private static KeyEvents.Builder backwardsBuilder() {
        return KeyEvents.builder(10).modifiers(64).condition(0).action(TransferFocusOnEnter.backwardAction());
    }

    private static <T extends JComponent> KeyEvents.Builder forwardBuilder(T component) {
        return KeyEvents.builder(10).modifiers(component instanceof JTextArea ? 128 : 0).condition(0).action(TransferFocusOnEnter.forwardAction());
    }

    private static final class TransferFocusAction
    extends AbstractAction {
        private final boolean backward;

        private TransferFocusAction(boolean backward) {
            super(backward ? "TransferFocusOnEnter.transferFocusBackward" : "KeyTransferFocusOnEnter.transferFocusForward");
            this.backward = backward;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent source = (JComponent)e.getSource();
            if (this.backward) {
                source.transferFocusBackward();
            } else {
                source.transferFocus();
            }
        }
    }
}

