/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.i18n.Messages;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.swing.common.model.worker.ProgressWorker;
import is.codion.swing.common.ui.UiManagerDefaults;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.progressbar.ProgressBarBuilder;
import is.codion.swing.common.ui.component.text.PasswordFieldBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.DefaultExceptionDialogBuilder;
import is.codion.swing.common.ui.dialog.ExceptionDialogBuilder;
import is.codion.swing.common.ui.dialog.LoginDialogBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

final class LoginPanel
extends JPanel {
    private static final String PASSWORD_CARD = "password";
    private static final String PROGRESS_CARD = "progress";
    private final JTextField usernameField;
    private final JPasswordField passwordField;
    private final Value<User> user = Value.value();
    private final LoginDialogBuilder.LoginValidator loginValidator;
    private final ImageIcon icon;
    private final Control okControl;
    private final Control cancelControl;
    private final State validating = State.state();

    LoginPanel(User defaultUser, LoginDialogBuilder.LoginValidator loginValidator, ImageIcon icon, JComponent southComponent, int inputFieldColumns) {
        Value usernameValue = Value.value((Object)(defaultUser == null ? null : defaultUser.username()));
        this.usernameField = (JTextField)((TextFieldBuilder)((TextFieldBuilder)TextFieldBuilder.builder(String.class, usernameValue).columns(inputFieldColumns).selectAllOnFocusGained(true)).enabled(this.validating.not())).build();
        this.passwordField = (JPasswordField)((PasswordFieldBuilder)((PasswordFieldBuilder)((PasswordFieldBuilder)PasswordFieldBuilder.builder().initialValue(defaultUser == null ? "" : String.valueOf(defaultUser.password()))).columns(inputFieldColumns)).selectAllOnFocusGained(true)).build();
        this.icon = icon;
        this.okControl = Control.builder(this::onOkPressed).name(Messages.ok()).mnemonic(Messages.okMnemonic()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{LoginPanel.usernameSpecifiedState((Value<String>)usernameValue), this.validating.not()})).build();
        this.cancelControl = Control.builder(this::closeDialog).name(Messages.cancel()).mnemonic(Messages.cancelMnemonic()).enabled(this.validating.not()).build();
        this.loginValidator = Objects.requireNonNull(loginValidator);
        this.initializeUI(southComponent);
    }

    User user() {
        return (User)this.user.get();
    }

    Control okControl() {
        return this.okControl;
    }

    Control cancelControl() {
        return this.cancelControl;
    }

    void requestInitialFocus() {
        if (this.usernameField.getText().isEmpty()) {
            this.usernameField.requestFocusInWindow();
        } else {
            this.passwordField.requestFocusInWindow();
        }
    }

    private void initializeUI(JComponent southComponent) {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        GridBagConstraints constraints = LoginPanel.createGridBagConstraints();
        if (this.icon != null) {
            this.add((Component)new JLabel(this.icon, 0), constraints);
        }
        this.add((Component)this.createCredentialsBasePanel(southComponent), constraints);
    }

    private JPanel createCredentialsBasePanel(JComponent southComponent) {
        JPanel credentialsBasePanel = new JPanel(Layouts.borderLayout());
        credentialsBasePanel.add((Component)this.createCredentialsPanel(), "Center");
        if (southComponent != null) {
            credentialsBasePanel.add((Component)southComponent, "South");
        }
        return credentialsBasePanel;
    }

    private JPanel createCredentialsPanel() {
        return (JPanel)PanelBuilder.builder(Layouts.flexibleGridLayout(2, 2)).add(new JLabel(Messages.username(), 4)).add(this.usernameField).add(new JLabel(Messages.password(), 4)).add(this.createPasswordProgressPanel()).build();
    }

    private JPanel createPasswordProgressPanel() {
        CardLayout passwordProgressLayout = new CardLayout();
        JPanel passwordProgressPanel = (JPanel)PanelBuilder.builder(passwordProgressLayout).add(this.passwordField, PASSWORD_CARD).add(((ProgressBarBuilder)ProgressBarBuilder.builder().preferredSize(this.passwordField.getPreferredSize())).build(), PROGRESS_CARD).build();
        this.validating.addDataListener(isValidating -> passwordProgressLayout.show(passwordProgressPanel, isValidating != false ? PROGRESS_CARD : PASSWORD_CARD));
        return passwordProgressPanel;
    }

    private void onOkPressed() {
        ProgressWorker.builder(this::validateLogin).onStarted(this::onValidationStarted).onResult(this::onValidationSuccess).onException(this::onValidationFailure).execute();
    }

    private User validateLogin() throws Exception {
        User currentUser = User.user((String)this.usernameField.getText(), (char[])this.passwordField.getPassword());
        this.loginValidator.validate(currentUser);
        return currentUser;
    }

    private void onValidationStarted() {
        this.validating.set((Object)true);
    }

    private void onValidationSuccess(User user) {
        this.user.set((Object)user);
        this.validating.set((Object)false);
        this.closeDialog();
    }

    private void onValidationFailure(Throwable exception) {
        this.user.set(null);
        this.validating.set((Object)false);
        ((ExceptionDialogBuilder)new DefaultExceptionDialogBuilder().owner(Utilities.parentWindow(this))).show(exception);
        this.requestInitialFocus();
    }

    private void closeDialog() {
        Utilities.disposeParentWindow(this);
    }

    private static State usernameSpecifiedState(Value<String> usernameValue) {
        State usernameSpecified = State.state((boolean)usernameValue.isNotNull());
        usernameValue.addDataListener(username -> usernameSpecified.set((Object)(username != null ? 1 : 0)));
        return usernameSpecified;
    }

    private static GridBagConstraints createGridBagConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        int insets = (Integer)Layouts.GAP.get();
        constraints.insets = new Insets(insets, insets, insets, insets);
        return constraints;
    }

    static {
        UiManagerDefaults.initialize();
    }
}

