/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.list;

import is.codion.common.value.ValueSet;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.list.ListBuilder;
import is.codion.swing.common.ui.component.list.ListValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

final class DefaultListBuilder<T>
extends AbstractComponentBuilder<Set<T>, JList<T>, ListBuilder<T>>
implements ListBuilder<T> {
    private final ListModel<T> listModel;
    private final List<ListSelectionListener> listSelectionListeners = new ArrayList<ListSelectionListener>();
    private ListCellRenderer<T> cellRenderer;
    private ListSelectionModel selectionModel;
    private int visibleRowCount;
    private int layoutOrientation = 0;
    private int fixedCellHeight = -1;
    private int fixedCellWidth = -1;
    private int selectionMode = 2;

    DefaultListBuilder(ListModel<T> listModel, ValueSet<T> linkedValueSet) {
        super(linkedValueSet);
        this.listModel = Objects.requireNonNull(listModel);
    }

    @Override
    public ListBuilder<T> visibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
        return this;
    }

    @Override
    public ListBuilder<T> layoutOrientation(int layoutOrientation) {
        this.layoutOrientation = layoutOrientation;
        return this;
    }

    @Override
    public ListBuilder<T> fixedCellHeight(int fixedCellHeight) {
        this.fixedCellHeight = fixedCellHeight;
        return this;
    }

    @Override
    public ListBuilder<T> fixedCellWidth(int fixedCellWidth) {
        this.fixedCellWidth = fixedCellWidth;
        return this;
    }

    @Override
    public ListBuilder<T> cellRenderer(ListCellRenderer<T> cellRenderer) {
        this.cellRenderer = Objects.requireNonNull(cellRenderer);
        return this;
    }

    @Override
    public ListBuilder<T> selectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        return this;
    }

    @Override
    public ListBuilder<T> selectionModel(ListSelectionModel selectionModel) {
        this.selectionModel = Objects.requireNonNull(selectionModel);
        return this;
    }

    @Override
    public ListBuilder<T> listSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionListeners.add(Objects.requireNonNull(listSelectionListener));
        return this;
    }

    @Override
    protected JList<T> createComponent() {
        JList<T> list = new JList<T>(this.listModel);
        if (this.cellRenderer != null) {
            list.setCellRenderer(this.cellRenderer);
        }
        if (this.selectionModel != null) {
            list.setSelectionModel(this.selectionModel);
        }
        this.listSelectionListeners.forEach(new AddListSelectionListener(list));
        list.setVisibleRowCount(this.visibleRowCount);
        list.setLayoutOrientation(this.layoutOrientation);
        list.setFixedCellHeight(this.fixedCellHeight);
        list.setFixedCellWidth(this.fixedCellWidth);
        list.setSelectionMode(this.selectionMode);
        return list;
    }

    @Override
    protected ComponentValue<Set<T>, JList<T>> createComponentValue(JList<T> component) {
        return new ListValue<T>(component);
    }

    @Override
    protected void setInitialValue(JList<T> component, Set<T> initialValue) {
        ListValue.selectValues(component, initialValue);
    }

    private static final class AddListSelectionListener
    implements Consumer<ListSelectionListener> {
        private final JList<?> list;

        private AddListSelectionListener(JList<?> list) {
            this.list = list;
        }

        @Override
        public void accept(ListSelectionListener listener) {
            this.list.addListSelectionListener(listener);
        }
    }
}

