/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.laf;

import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.laf.LookAndFeelProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

final class DefaultLookAndFeelProvider
implements LookAndFeelProvider {
    private static final Consumer<UIManager.LookAndFeelInfo> DEFAULT_ENABLER = new DefaultEnabler();
    static final Map<String, LookAndFeelProvider> LOOK_AND_FEEL_PROVIDERS = new HashMap<String, LookAndFeelProvider>();
    private final UIManager.LookAndFeelInfo lookAndFeelInfo;
    private final Consumer<UIManager.LookAndFeelInfo> enabler;

    DefaultLookAndFeelProvider(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        this(lookAndFeelInfo, DEFAULT_ENABLER);
    }

    DefaultLookAndFeelProvider(UIManager.LookAndFeelInfo lookAndFeelInfo, Consumer<UIManager.LookAndFeelInfo> enabler) {
        this.lookAndFeelInfo = Objects.requireNonNull(lookAndFeelInfo);
        this.enabler = Objects.requireNonNull(enabler);
    }

    @Override
    public UIManager.LookAndFeelInfo lookAndFeelInfo() {
        return this.lookAndFeelInfo;
    }

    @Override
    public void enable() {
        this.enabler.accept(this.lookAndFeelInfo);
    }

    @Override
    public LookAndFeel lookAndFeel() throws Exception {
        return (LookAndFeel)Class.forName(this.lookAndFeelInfo.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public String toString() {
        return this.lookAndFeelInfo.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultLookAndFeelProvider)) {
            return false;
        }
        DefaultLookAndFeelProvider that = (DefaultLookAndFeelProvider)obj;
        return this.lookAndFeelInfo.getClassName().equals(that.lookAndFeelInfo.getClassName());
    }

    public int hashCode() {
        return this.lookAndFeelInfo().getClassName().hashCode();
    }

    static {
        LookAndFeelProvider crossPlatformProvider = LookAndFeelProvider.lookAndFeelProvider(new UIManager.LookAndFeelInfo("Cross Platform", UIManager.getCrossPlatformLookAndFeelClassName()));
        LOOK_AND_FEEL_PROVIDERS.put(crossPlatformProvider.lookAndFeelInfo().getClassName(), crossPlatformProvider);
        LookAndFeelProvider systemProvider = LookAndFeelProvider.lookAndFeelProvider(new UIManager.LookAndFeelInfo("System", Utilities.systemLookAndFeelClassName()));
        if (!LOOK_AND_FEEL_PROVIDERS.containsKey(systemProvider.lookAndFeelInfo().getClassName())) {
            LOOK_AND_FEEL_PROVIDERS.put(systemProvider.lookAndFeelInfo().getClassName(), systemProvider);
        }
    }

    private static final class DefaultEnabler
    implements Consumer<UIManager.LookAndFeelInfo> {
        private DefaultEnabler() {
        }

        @Override
        public void accept(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            try {
                UIManager.setLookAndFeel(Objects.requireNonNull(lookAndFeelInfo).getClassName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

