/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.icon;

import is.codion.swing.common.ui.icon.DefaultFontImageIcon;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.ImageIcon;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.swing.FontIcon;

public interface FontImageIcon {
    public ImageIcon imageIcon();

    public void color(Color var1);

    public static Builder builder(Ikon ikon) {
        return new DefaultFontImageIcon.DefaultBuilder(ikon);
    }

    public static interface Builder {
        public Builder size(int var1);

        public Builder color(Color var1);

        public Builder iconPainter(IconPainter var1);

        public Builder imageIconFactory(ImageIconFactory var1);

        public FontImageIcon build();
    }

    public static interface ImageIconFactory {
        default public ImageIcon createImageIcon(FontIcon fontIcon) {
            return new ImageIcon(new BufferedImage(Objects.requireNonNull(fontIcon).getIconWidth(), fontIcon.getIconHeight(), 2));
        }
    }

    public static interface IconPainter {
        default public void paintIcon(FontIcon fontIcon, ImageIcon imageIcon) {
            Objects.requireNonNull(fontIcon).paintIcon(null, Objects.requireNonNull(imageIcon).getImage().getGraphics(), 0, 0);
        }
    }
}

