/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.icon;

import is.codion.swing.common.ui.icon.FontImageIcon;
import is.codion.swing.common.ui.icon.Icons;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.kordamp.ikonli.Ikon;

final class DefaultIcons
implements Icons {
    private static final String BUTTON_FOREGROUND_PROPERTY = "Button.foreground";
    private final Map<Ikon, FontImageIcon> icons = new HashMap<Ikon, FontImageIcon>();
    private final OnIconColorChangedListener onIconColorChangedListener = new OnIconColorChangedListener();

    DefaultIcons() {
    }

    @Override
    public void add(Ikon ... ikons) {
        for (Ikon ikon : Objects.requireNonNull(ikons)) {
            if (!this.icons.containsKey(Objects.requireNonNull(ikon))) continue;
            throw new IllegalArgumentException("Icon has already been added: " + ikon);
        }
        for (Ikon ikon : ikons) {
            this.icons.put(ikon, FontImageIcon.builder(ikon).build());
        }
    }

    @Override
    public ImageIcon icon(Ikon ikon) {
        if (!this.icons.containsKey(Objects.requireNonNull(ikon))) {
            throw new IllegalArgumentException("No icon has been added for key: " + ikon);
        }
        return this.icons.get(ikon).imageIcon();
    }

    @Override
    public void iconColor(Color color) {
        Objects.requireNonNull(color);
        this.icons.values().forEach(icon -> icon.color(color));
    }

    @Override
    public Icons enableIconColorListener() {
        ICON_COLOR.addWeakDataListener((Consumer)this.onIconColorChangedListener);
        return this;
    }

    @Override
    public Icons disableIconColorListener() {
        ICON_COLOR.removeWeakDataListener((Consumer)this.onIconColorChangedListener);
        return this;
    }

    static {
        UIManager.addPropertyChangeListener(new OnLookAndFeelChangedListener());
    }

    private final class OnIconColorChangedListener
    implements Consumer<Color> {
        private OnIconColorChangedListener() {
        }

        @Override
        public void accept(Color color) {
            if (color != null) {
                DefaultIcons.this.iconColor(color);
            }
        }
    }

    private static final class OnLookAndFeelChangedListener
    implements PropertyChangeListener {
        private static final String LOOK_AND_FEEL_PROPERTY = "lookAndFeel";

        private OnLookAndFeelChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(LOOK_AND_FEEL_PROPERTY) && Icons.ICON_COLOR != null) {
                Icons.ICON_COLOR.set((Object)UIManager.getColor(DefaultIcons.BUTTON_FOREGROUND_PROPERTY));
            }
        }
    }
}

