/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.i18n.Messages;
import is.codion.common.state.StateObserver;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.DefaultActionDialogBuilder;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;

final class DefaultOkCancelDialogBuilder
extends DefaultActionDialogBuilder<OkCancelDialogBuilder>
implements OkCancelDialogBuilder {
    private StateObserver okEnabled;
    private StateObserver cancelEnabled;
    private Runnable onOk;
    private Runnable onCancel;
    private Action okAction;
    private Action cancelAction;

    DefaultOkCancelDialogBuilder(JComponent component) {
        super(component);
    }

    @Override
    public OkCancelDialogBuilder action(Action action) {
        throw new UnsupportedOperationException("Adding an action directly is not supported");
    }

    @Override
    public OkCancelDialogBuilder defaultAction(Action defaultAction) {
        throw new UnsupportedOperationException("Adding a default action is not supported");
    }

    @Override
    public OkCancelDialogBuilder escapeAction(Action escapeAction) {
        throw new UnsupportedOperationException("Adding an escape action is not supported");
    }

    @Override
    public OkCancelDialogBuilder okEnabled(StateObserver okEnabled) {
        if (this.okAction != null) {
            throw new IllegalStateException("OK action has already been set");
        }
        this.okEnabled = Objects.requireNonNull(okEnabled);
        return this;
    }

    @Override
    public OkCancelDialogBuilder cancelEnabled(StateObserver cancelEnabled) {
        if (this.cancelAction != null) {
            throw new IllegalStateException("Cancel action has already been set");
        }
        this.cancelEnabled = Objects.requireNonNull(cancelEnabled);
        return this;
    }

    @Override
    public OkCancelDialogBuilder onOk(Runnable onOk) {
        if (this.okAction != null) {
            throw new IllegalStateException("OK action has already been set");
        }
        this.onOk = Objects.requireNonNull(onOk);
        return this;
    }

    @Override
    public OkCancelDialogBuilder onCancel(Runnable onCancel) {
        if (this.cancelAction != null) {
            throw new IllegalStateException("Cancel action has already been set");
        }
        this.onCancel = Objects.requireNonNull(onCancel);
        return this;
    }

    @Override
    public OkCancelDialogBuilder okAction(Action okAction) {
        if (this.onOk != null) {
            throw new IllegalStateException("onOk has already been set");
        }
        this.okAction = Objects.requireNonNull(okAction);
        return this;
    }

    @Override
    public OkCancelDialogBuilder cancelAction(Action cancelAction) {
        if (this.onCancel != null) {
            throw new IllegalStateException("onCancel has already been set");
        }
        this.cancelAction = Objects.requireNonNull(cancelAction);
        return this;
    }

    @Override
    public JDialog build() {
        this.controls().removeAll();
        if (this.okAction == null) {
            this.okAction = Control.builder(this.onOk == null ? new DefaultOkCommand(this.component()) : new PerformAndCloseCommand(this.onOk, this.component())).name(Messages.ok()).mnemonic(Messages.okMnemonic()).enabled(this.okEnabled).build();
        }
        if (this.cancelAction == null) {
            this.cancelAction = Control.builder(this.onCancel == null ? new DefaultCancelCommand(this.component()) : new PerformAndCloseCommand(this.onCancel, this.component())).name(Messages.cancel()).mnemonic(Messages.cancelMnemonic()).enabled(this.cancelEnabled).build();
        }
        this.okAction.putValue("Name", Messages.ok());
        this.okAction.putValue("MnemonicKey", Messages.okMnemonic());
        this.cancelAction.putValue("Name", Messages.cancel());
        this.cancelAction.putValue("MnemonicKey", Messages.cancelMnemonic());
        super.defaultAction(this.okAction);
        super.escapeAction(this.cancelAction);
        return super.build();
    }

    private static final class DefaultOkCommand
    implements Control.Command {
        private final JComponent component;

        private DefaultOkCommand(JComponent component) {
            this.component = component;
        }

        @Override
        public void execute() {
            Utilities.disposeParentWindow(this.component);
        }
    }

    private static final class PerformAndCloseCommand
    implements Control.Command {
        private final Runnable command;
        private final JComponent component;

        private PerformAndCloseCommand(Runnable command, JComponent component) {
            this.command = command;
            this.component = component;
        }

        @Override
        public void execute() {
            this.command.run();
            Utilities.disposeParentWindow(this.component);
        }
    }

    private static final class DefaultCancelCommand
    implements Control.Command {
        private final JComponent component;

        private DefaultCancelCommand(JComponent component) {
            this.component = component;
        }

        @Override
        public void execute() {
            Utilities.disposeParentWindow(this.component);
        }
    }
}

