/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.value.Value;
import is.codion.swing.common.model.component.text.DocumentAdapter;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.text.DefaultTextFieldBuilder;
import is.codion.swing.common.ui.component.text.SizedDocument;
import is.codion.swing.common.ui.component.text.TextAreaBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.component.text.UpdateOn;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.common.ui.key.TransferFocusOnEnter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;

public final class TextFieldPanel
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(TextFieldPanel.class.getName());
    public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class, TextFieldPanel::defaultKeyStroke);
    private final JTextField textField;
    private final JButton button;
    private final String dialogTitle;
    private final String caption;
    private final Dimension textAreaSize;
    private final int maximumLength;

    private TextFieldPanel(DefaultBuilder builder) {
        this.textField = (JTextField)builder.textFieldBuilder.build();
        this.dialogTitle = builder.dialogTitle;
        this.textAreaSize = builder.textAreaSize;
        this.button = this.createButton(builder.buttonFocusable, builder.buttonIcon, builder.keyboardShortcuts);
        this.caption = builder.caption;
        this.maximumLength = builder.maximumLength;
        this.initializeUI();
    }

    public void setText(String text) {
        if (text != null && this.maximumLength > 0 && text.length() > this.maximumLength) {
            throw new IllegalArgumentException("Maximum allowed text length exceeded");
        }
        this.textField.setText(text == null ? "" : text);
    }

    public String getText() {
        String text = this.textField.getText();
        return text.isEmpty() ? null : text;
    }

    public JTextField textField() {
        return this.textField;
    }

    public JButton button() {
        return this.button;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String text) {
        this.textField.setToolTipText(text);
    }

    public void transferFocusOnEnter(boolean transferFocusOnEnter) {
        if (transferFocusOnEnter) {
            TransferFocusOnEnter.enable(this.textField);
            TransferFocusOnEnter.enable(this.button);
        } else {
            TransferFocusOnEnter.disable(this.textField);
            TransferFocusOnEnter.disable(this.button);
        }
    }

    public static Builder builder() {
        return new DefaultBuilder(null);
    }

    public static Builder builder(Value<String> linkedValue) {
        return new DefaultBuilder(Objects.requireNonNull(linkedValue));
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)this.button, "East");
        if (this.caption != null) {
            this.setBorder(BorderFactory.createTitledBorder(this.caption));
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextFieldPanel.this.textField.requestFocusInWindow();
            }
        });
    }

    private JButton createButton(boolean buttonFocusable, ImageIcon buttonIcon, KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts) {
        Object buttonControl = Control.builder(this::inputFromUser).name(buttonIcon == null ? "..." : "").smallIcon(buttonIcon).build();
        KeyEvents.builder((KeyStroke)keyboardShortcuts.keyStroke(KeyboardShortcut.DISPLAY_TEXT_AREA).get()).action((Action)buttonControl).enable(this.textField);
        JButton actionButton = new JButton((Action)buttonControl);
        actionButton.setFocusable(buttonFocusable);
        actionButton.setToolTipText(MESSAGES.getString("show_input_dialog"));
        actionButton.setPreferredSize(new Dimension(this.textField.getPreferredSize().height, this.textField.getPreferredSize().height));
        return actionButton;
    }

    private void inputFromUser() {
        JTextArea textArea = (JTextArea)((TextAreaBuilder)((TextAreaBuilder)((TextAreaBuilder)((TextAreaBuilder)TextAreaBuilder.builder().document(SizedDocument.sizedDocument(this.maximumLength)).initialValue(this.textField.getText())).preferredSize(this.textAreaSize)).lineWrap(true).wrapStyleWord(true).editable(this.textField.isEditable())).moveCaretToEndOnFocusGained(true)).build();
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog(new JScrollPane(textArea)).owner(this.textField)).title(this.dialogTitle == null ? this.caption : this.dialogTitle)).onOk(() -> this.textField.setText(textArea.getText())).show();
    }

    private static KeyStroke defaultKeyStroke(KeyboardShortcut shortcut) {
        if (shortcut == KeyboardShortcut.DISPLAY_TEXT_AREA) {
            return KeyboardShortcuts.keyStroke(155, 0);
        }
        throw new IllegalArgumentException();
    }

    private static final class DefaultBuilder
    extends AbstractComponentBuilder<String, TextFieldPanel, Builder>
    implements Builder {
        private static final Dimension DEFAULT_TEXT_AREA_SIZE = new Dimension(500, 300);
        private final TextFieldBuilder<String, JTextField, ?> textFieldBuilder = new DefaultTextFieldBuilder(String.class, null);
        private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts = KEYBOARD_SHORTCUTS.copy();
        private boolean buttonFocusable;
        private ImageIcon buttonIcon;
        private Dimension textAreaSize = DEFAULT_TEXT_AREA_SIZE;
        private int maximumLength;
        private String caption;
        private String dialogTitle;

        private DefaultBuilder(Value<String> linkedValue) {
            super(linkedValue);
        }

        @Override
        public Builder updateOn(UpdateOn updateOn) {
            this.textFieldBuilder.updateOn(updateOn);
            return this;
        }

        @Override
        public Builder columns(int columns) {
            this.textFieldBuilder.columns(columns);
            return this;
        }

        @Override
        public Builder upperCase(boolean upperCase) {
            this.textFieldBuilder.upperCase(upperCase);
            return this;
        }

        @Override
        public Builder lowerCase(boolean lowerCase) {
            this.textFieldBuilder.lowerCase(lowerCase);
            return this;
        }

        @Override
        public Builder selectAllOnFocusGained(boolean selectAllOnFocusGained) {
            this.textFieldBuilder.selectAllOnFocusGained(selectAllOnFocusGained);
            return this;
        }

        @Override
        public Builder buttonFocusable(boolean buttonFocusable) {
            this.buttonFocusable = buttonFocusable;
            return this;
        }

        @Override
        public Builder buttonIcon(ImageIcon buttonIcon) {
            this.buttonIcon = buttonIcon;
            return this;
        }

        @Override
        public Builder textAreaSize(Dimension textAreaSize) {
            this.textAreaSize = Objects.requireNonNull(textAreaSize);
            return this;
        }

        @Override
        public Builder maximumLength(int maximumLength) {
            this.textFieldBuilder.maximumLength(maximumLength);
            this.maximumLength = maximumLength;
            return this;
        }

        @Override
        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Override
        public Builder dialogTitle(String dialogTitle) {
            this.dialogTitle = dialogTitle;
            return this;
        }

        @Override
        public Builder keyStroke(KeyboardShortcut keyboardShortcut, KeyStroke keyStroke) {
            this.keyboardShortcuts.keyStroke(keyboardShortcut).set((Object)keyStroke);
            return this;
        }

        @Override
        protected TextFieldPanel createComponent() {
            return new TextFieldPanel(this);
        }

        @Override
        protected ComponentValue<String, TextFieldPanel> createComponentValue(TextFieldPanel component) {
            return new TextFieldPanelValue(component);
        }

        @Override
        protected void setInitialValue(TextFieldPanel component, String initialValue) {
            component.setText(initialValue);
        }

        @Override
        protected void enableTransferFocusOnEnter(TextFieldPanel component) {
            component.transferFocusOnEnter(true);
        }
    }

    public static enum KeyboardShortcut {
        DISPLAY_TEXT_AREA;

    }

    private static class TextFieldPanelValue
    extends AbstractComponentValue<String, TextFieldPanel> {
        private TextFieldPanelValue(TextFieldPanel textFieldPanel) {
            super(textFieldPanel);
            textFieldPanel.textField().getDocument().addDocumentListener((DocumentListener)((DocumentAdapter)e -> this.notifyListeners()));
        }

        @Override
        protected String getComponentValue() {
            return ((TextFieldPanel)this.component()).getText();
        }

        @Override
        protected void setComponentValue(String value) {
            ((TextFieldPanel)this.component()).setText(value);
        }
    }

    public static interface Builder
    extends ComponentBuilder<String, TextFieldPanel, Builder> {
        public Builder updateOn(UpdateOn var1);

        public Builder columns(int var1);

        public Builder upperCase(boolean var1);

        public Builder lowerCase(boolean var1);

        public Builder selectAllOnFocusGained(boolean var1);

        public Builder dialogTitle(String var1);

        public Builder caption(String var1);

        public Builder textAreaSize(Dimension var1);

        public Builder buttonFocusable(boolean var1);

        public Builder buttonIcon(ImageIcon var1);

        public Builder maximumLength(int var1);

        public Builder keyStroke(KeyboardShortcut var1, KeyStroke var2);
    }
}

