/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.ui.component.table.DefaultFilteredTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilteredTableCellRenderer;
import java.time.temporal.Temporal;
import java.util.Objects;
import java.util.function.Function;

public class DefaultFilteredTableCellRendererBuilder<R, C>
implements FilteredTableCellRenderer.Builder<R, C> {
    final FilteredTableModel<R, C> tableModel;
    final C columnIdentifier;
    private final Class<?> columnClass;
    private final boolean useBooleanRenderer;
    int horizontalAlignment;
    boolean toolTipData;
    boolean columnShadingEnabled = true;
    boolean alternateRowColoring = (Boolean)FilteredTableCellRenderer.ALTERNATE_ROW_COLORING.get();
    int leftPadding = (Integer)FilteredTableCellRenderer.TABLE_CELL_LEFT_PADDING.get();
    int rightPadding = (Integer)FilteredTableCellRenderer.TABLE_CELL_RIGHT_PADDING.get();
    Function<Object, Object> displayValueProvider = new DefaultDisplayValueProvider();
    FilteredTableCellRenderer.CellColorProvider<C> cellColorProvider = new DefaultCellColorProvider<C>();

    protected DefaultFilteredTableCellRendererBuilder(FilteredTableModel<R, C> tableModel, C columnIdentifier, Class<?> columnClass) {
        this(tableModel, columnIdentifier, columnClass, Boolean.class.equals(Objects.requireNonNull(columnClass)));
    }

    protected DefaultFilteredTableCellRendererBuilder(FilteredTableModel<R, C> tableModel, C columnIdentifier, Class<?> columnClass, boolean useBooleanRenderer) {
        this.tableModel = Objects.requireNonNull(tableModel);
        this.columnIdentifier = Objects.requireNonNull(columnIdentifier);
        this.columnClass = Objects.requireNonNull(columnClass);
        this.useBooleanRenderer = useBooleanRenderer;
        this.horizontalAlignment = this.defaultHorizontalAlignment();
    }

    @Override
    public final FilteredTableCellRenderer.Builder<R, C> horizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @Override
    public final FilteredTableCellRenderer.Builder<R, C> toolTipData(boolean toolTipData) {
        this.toolTipData = toolTipData;
        return this;
    }

    @Override
    public final FilteredTableCellRenderer.Builder<R, C> columnShadingEnabled(boolean columnShadingEnabled) {
        this.columnShadingEnabled = columnShadingEnabled;
        return this;
    }

    @Override
    public final FilteredTableCellRenderer.Builder<R, C> alternateRowColoring(boolean alternateRowColoring) {
        this.alternateRowColoring = alternateRowColoring;
        return this;
    }

    @Override
    public final FilteredTableCellRenderer.Builder<R, C> leftPadding(int leftPadding) {
        this.leftPadding = leftPadding;
        return this;
    }

    @Override
    public final FilteredTableCellRenderer.Builder<R, C> rightPadding(int rightPadding) {
        this.rightPadding = rightPadding;
        return this;
    }

    @Override
    public final FilteredTableCellRenderer.Builder<R, C> displayValueProvider(Function<Object, Object> displayValueProvider) {
        this.displayValueProvider = Objects.requireNonNull(displayValueProvider);
        return this;
    }

    @Override
    public final FilteredTableCellRenderer.Builder<R, C> cellColorProvider(FilteredTableCellRenderer.CellColorProvider<C> cellColorProvider) {
        this.cellColorProvider = Objects.requireNonNull(cellColorProvider);
        return this;
    }

    @Override
    public final FilteredTableCellRenderer build() {
        return this.useBooleanRenderer ? new DefaultFilteredTableCellRenderer.BooleanRenderer(this, this.settings(this.leftPadding, this.rightPadding, this.alternateRowColoring)) : new DefaultFilteredTableCellRenderer(this, this.settings(this.leftPadding, this.rightPadding, this.alternateRowColoring));
    }

    protected FilteredTableCellRenderer.Settings<C> settings(int leftPadding, int rightPadding, boolean alternateRowColoring) {
        return new FilteredTableCellRenderer.Settings(leftPadding, rightPadding, alternateRowColoring);
    }

    private int defaultHorizontalAlignment() {
        if (this.useBooleanRenderer) {
            return (Integer)FilteredTableCellRenderer.BOOLEAN_HORIZONTAL_ALIGNMENT.get();
        }
        if (Number.class.isAssignableFrom(this.columnClass)) {
            return (Integer)FilteredTableCellRenderer.NUMERICAL_HORIZONTAL_ALIGNMENT.get();
        }
        if (Temporal.class.isAssignableFrom(this.columnClass)) {
            return (Integer)FilteredTableCellRenderer.TEMPORAL_HORIZONTAL_ALIGNMENT.get();
        }
        return (Integer)FilteredTableCellRenderer.HORIZONTAL_ALIGNMENT.get();
    }

    private static final class DefaultDisplayValueProvider
    implements Function<Object, Object> {
        private DefaultDisplayValueProvider() {
        }

        @Override
        public Object apply(Object value) {
            return value == null ? "" : value.toString();
        }
    }

    private static final class DefaultCellColorProvider<R>
    implements FilteredTableCellRenderer.CellColorProvider<R> {
        private DefaultCellColorProvider() {
        }
    }
}

