/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.swing.common.model.component.button.NullableToggleButtonModel;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.ui.component.button.NullableCheckBox;
import is.codion.swing.common.ui.component.table.DefaultFilteredTableCellRendererBuilder;
import is.codion.swing.common.ui.component.table.FilteredTableCellRenderer;
import java.awt.Component;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

final class DefaultFilteredTableCellRenderer<R, C>
extends DefaultTableCellRenderer
implements FilteredTableCellRenderer {
    private final FilteredTableCellRenderer.Settings<C> settings;
    private final FilteredTableModel<R, C> tableModel;
    private final C columnIdentifier;
    private final boolean toolTipData;
    private final boolean columnShadingEnabled;
    private final boolean alternateRowColoring;
    private final Function<Object, Object> displayValueProvider;
    private final FilteredTableCellRenderer.CellColorProvider<C> cellColorProvider;

    DefaultFilteredTableCellRenderer(DefaultFilteredTableCellRendererBuilder<R, C> builder, FilteredTableCellRenderer.Settings<C> settings) {
        this.tableModel = Objects.requireNonNull(builder).tableModel;
        this.settings = Objects.requireNonNull(settings);
        this.settings.updateColors();
        this.columnIdentifier = builder.columnIdentifier;
        this.toolTipData = builder.toolTipData;
        this.columnShadingEnabled = builder.columnShadingEnabled;
        this.alternateRowColoring = builder.alternateRowColoring;
        this.displayValueProvider = builder.displayValueProvider;
        this.cellColorProvider = builder.cellColorProvider;
        this.setHorizontalAlignment(builder.horizontalAlignment);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.settings != null) {
            this.settings.updateColors();
        }
    }

    @Override
    public boolean columnShadingEnabled() {
        return this.columnShadingEnabled;
    }

    @Override
    public boolean alternateRowColoring() {
        return this.alternateRowColoring;
    }

    @Override
    public int horizontalAlignment() {
        return this.getHorizontalAlignment();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setForeground(this.settings.foregroundColor(this.cellColorProvider.foregroundColor(row, this.columnIdentifier, value, isSelected)));
        this.setBackground(this.settings.backgroundColor(this.tableModel, row, this.columnIdentifier, this.columnShadingEnabled, isSelected, this.cellColorProvider.backgroundColor(row, this.columnIdentifier, value, isSelected)));
        this.setBorder(hasFocus || DefaultFilteredTableCellRenderer.isSearchResult(this.tableModel, row, column) ? this.settings.focusedCellBorder() : this.settings.defaultCellBorder());
        if (this.toolTipData) {
            this.setToolTipText(value == null ? "" : value.toString());
        }
        return this;
    }

    @Override
    protected void setValue(Object value) {
        super.setValue(this.displayValueProvider.apply(value));
    }

    FilteredTableCellRenderer.Settings<C> settings() {
        return this.settings;
    }

    private static boolean isSearchResult(FilteredTableModel<?, ?> tableModel, int row, int column) {
        return tableModel.searchModel().currentResult().equals(row, column);
    }

    public static final class BooleanRenderer<R, C>
    extends NullableCheckBox
    implements TableCellRenderer,
    UIResource,
    FilteredTableCellRenderer {
        private final FilteredTableCellRenderer.Settings<C> settings;
        private final FilteredTableModel<R, C> tableModel;
        private final C columnIdentifier;
        private final boolean columnShadingEnabled;
        private final boolean alternateRowColoring;
        private final FilteredTableCellRenderer.CellColorProvider<C> cellColorProvider;

        BooleanRenderer(DefaultFilteredTableCellRendererBuilder<R, C> builder, FilteredTableCellRenderer.Settings<C> settings) {
            super(new NullableToggleButtonModel());
            this.tableModel = Objects.requireNonNull(builder).tableModel;
            this.settings = Objects.requireNonNull(settings);
            this.settings.updateColors();
            this.columnIdentifier = Objects.requireNonNull(builder.columnIdentifier);
            this.columnShadingEnabled = builder.columnShadingEnabled;
            this.alternateRowColoring = builder.alternateRowColoring;
            this.cellColorProvider = builder.cellColorProvider;
            this.setHorizontalAlignment(builder.horizontalAlignment);
            this.setBorderPainted(true);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.settings != null) {
                this.settings.updateColors();
            }
        }

        @Override
        public boolean columnShadingEnabled() {
            return this.columnShadingEnabled;
        }

        @Override
        public boolean alternateRowColoring() {
            return this.alternateRowColoring;
        }

        @Override
        public int horizontalAlignment() {
            return this.getHorizontalAlignment();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.getNullableModel().setState((Boolean)value);
            this.setForeground(this.settings.foregroundColor(this.cellColorProvider.foregroundColor(row, this.columnIdentifier, value, isSelected)));
            this.setBackground(this.settings.backgroundColor(this.tableModel, row, this.columnIdentifier, this.columnShadingEnabled, isSelected, this.cellColorProvider.backgroundColor(row, this.columnIdentifier, value, isSelected)));
            this.setBorder(hasFocus || DefaultFilteredTableCellRenderer.isSearchResult(this.tableModel, row, column) ? this.settings.focusedCellBorder() : this.settings.defaultCellBorder());
            return this;
        }
    }
}

