/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.label;

import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.label.LabelBuilder;
import is.codion.swing.common.ui.component.label.LabelComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

final class DefaultLabelBuilder<T>
extends AbstractComponentBuilder<T, JLabel, LabelBuilder<T>>
implements LabelBuilder<T> {
    private final String text;
    private Icon icon;
    private int horizontalAlignment = (Integer)HORIZONTAL_ALIGNMENT.get();
    private Integer displayedMnemonic;
    private Character displayedMnemonicChar;
    private int iconTextGap = -1;
    private JComponent component;

    DefaultLabelBuilder(Icon icon) {
        this.text = null;
        this.icon(Objects.requireNonNull(icon));
        this.horizontalAlignment(0);
    }

    DefaultLabelBuilder(String text) {
        this.text = text;
    }

    DefaultLabelBuilder(ValueObserver<T> linkedValue) {
        this.text = null;
        this.linkedValue(Objects.requireNonNull(linkedValue));
    }

    @Override
    public LabelBuilder<T> horizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @Override
    public LabelBuilder<T> displayedMnemonic(int displayedMnemonic) {
        this.displayedMnemonic = displayedMnemonic;
        return this;
    }

    @Override
    public LabelBuilder<T> displayedMnemonic(char displayedMnemonic) {
        this.displayedMnemonicChar = Character.valueOf(displayedMnemonic);
        return this;
    }

    @Override
    public LabelBuilder<T> labelFor(JComponent component) {
        this.component = component;
        return this;
    }

    @Override
    public LabelBuilder<T> icon(Icon icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public LabelBuilder<T> iconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
        return this;
    }

    @Override
    protected JLabel createComponent() {
        JLabel label = new JLabel(this.text, this.icon, this.horizontalAlignment);
        if (this.displayedMnemonic != null) {
            label.setDisplayedMnemonic(this.displayedMnemonic);
        }
        if (this.displayedMnemonicChar != null) {
            label.setDisplayedMnemonic(this.displayedMnemonicChar.charValue());
        }
        if (this.component != null) {
            label.setLabelFor(this.component);
        }
        if (this.iconTextGap >= 0) {
            label.setIconTextGap(this.iconTextGap);
        }
        return label;
    }

    @Override
    protected ComponentValue<T, JLabel> createComponentValue(JLabel component) {
        return new LabelComponentValue(component);
    }

    @Override
    protected void setInitialValue(JLabel component, T initialValue) {
        component.setText(initialValue.toString());
    }
}

