/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.combobox;

import is.codion.swing.common.model.component.combobox.FilteredComboBoxModel;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

final class SelectedValue<T, C extends JComboBox<T>>
extends AbstractComponentValue<T, C> {
    SelectedValue(C comboBox) {
        super(comboBox);
        if (((JComboBox)comboBox).getModel() instanceof FilteredComboBoxModel) {
            ((FilteredComboBoxModel)((JComboBox)comboBox).getModel()).addSelectionListener(selected -> this.notifyListeners());
        } else {
            ((JComboBox)comboBox).addItemListener(new NotifyOnItemSelectedListener());
        }
    }

    @Override
    protected T getComponentValue() {
        ComboBoxModel comboBoxModel = ((JComboBox)this.component()).getModel();
        if (comboBoxModel instanceof FilteredComboBoxModel) {
            return (T)((FilteredComboBoxModel)comboBoxModel).selectedValue();
        }
        return (T)comboBoxModel.getSelectedItem();
    }

    @Override
    protected void setComponentValue(T value) {
        ((JComboBox)this.component()).getModel().setSelectedItem(value);
    }

    private final class NotifyOnItemSelectedListener
    implements ItemListener {
        private NotifyOnItemSelectedListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                SelectedValue.this.notifyListeners();
            }
        }
    }
}

