/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.state.StateObserver;
import is.codion.swing.common.ui.control.AbstractControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.DefaultActionControl;
import is.codion.swing.common.ui.control.DefaultControl;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.KeyStroke;

final class ControlBuilder
implements Control.Builder {
    private final Control.Command command;
    private final Control.ActionCommand actionCommand;
    private String name;
    private StateObserver enabled;
    private char mnemonic;
    private Icon smallIcon;
    private Icon largeIcon;
    private String description;
    private KeyStroke keyStroke;

    ControlBuilder(Control.ActionCommand actionCommand) {
        this.actionCommand = Objects.requireNonNull(actionCommand);
        this.command = null;
    }

    ControlBuilder(Control.Command command) {
        this.command = Objects.requireNonNull(command);
        this.actionCommand = null;
    }

    @Override
    public Control.Builder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Control.Builder enabled(StateObserver enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public Control.Builder mnemonic(char mnemonic) {
        this.mnemonic = mnemonic;
        return this;
    }

    @Override
    public Control.Builder smallIcon(Icon smallIcon) {
        this.smallIcon = smallIcon;
        return this;
    }

    @Override
    public Control.Builder largeIcon(Icon largeIcon) {
        this.largeIcon = largeIcon;
        return this;
    }

    @Override
    public Control.Builder description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Control.Builder keyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
        return this;
    }

    @Override
    public Control build() {
        AbstractControl control = this.command != null ? new DefaultControl(this.command, this.name, this.enabled) : new DefaultActionControl(this.actionCommand, this.name, this.enabled);
        control.setMnemonic(this.mnemonic);
        control.setSmallIcon(this.smallIcon);
        control.setLargeIcon(this.largeIcon);
        control.setDescription(this.description);
        control.setKeyStroke(this.keyStroke);
        return control;
    }
}

