/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.event.Event;
import is.codion.common.state.StateObserver;
import is.codion.swing.common.ui.control.ControlBuilder;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public interface Control
extends Action {
    public static final String FONT = "Font";
    public static final String BACKGROUND = "Background";
    public static final String FOREGROUND = "Foreground";

    public void setDescription(String var1);

    public String getDescription();

    public String getName();

    public void setName(String var1);

    public StateObserver enabled();

    public void setMnemonic(int var1);

    public int getMnemonic();

    public void setKeyStroke(KeyStroke var1);

    public KeyStroke getKeyStroke();

    public void setSmallIcon(Icon var1);

    public Icon getSmallIcon();

    public void setLargeIcon(Icon var1);

    public Icon getLargeIcon();

    public void setBackground(Color var1);

    public Color getBackground();

    public void setForeground(Color var1);

    public Color getForeground();

    public void setFont(Font var1);

    public Font getFont();

    @Override
    public void setEnabled(boolean var1);

    public static Control control(Command command) {
        return Control.builder(command).build();
    }

    public static Control actionControl(ActionCommand actionCommand) {
        return Control.actionControlBuilder(actionCommand).build();
    }

    public static Control eventControl(Event<ActionEvent> event) {
        return Control.eventControlBuilder(event).build();
    }

    public static Builder builder(Command command) {
        return new ControlBuilder(command);
    }

    public static Builder actionControlBuilder(ActionCommand actionCommand) {
        return new ControlBuilder(actionCommand);
    }

    public static Builder eventControlBuilder(Event<ActionEvent> event) {
        Objects.requireNonNull(event, "event");
        return new ControlBuilder(arg_0 -> event.accept(arg_0));
    }

    public static interface Command {
        public void perform() throws Exception;
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder enabled(StateObserver var1);

        public Builder mnemonic(char var1);

        public Builder smallIcon(Icon var1);

        public Builder largeIcon(Icon var1);

        public Builder description(String var1);

        public Builder keyStroke(KeyStroke var1);

        public Control build();
    }

    public static interface ActionCommand {
        public void perform(ActionEvent var1) throws Exception;
    }
}

