/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.text.UpdateOn;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.time.temporal.Temporal;

final class TemporalFieldValue<T extends Temporal>
extends AbstractComponentValue<T, TemporalField<T>> {
    TemporalFieldValue(TemporalField<T> component, UpdateOn updateOn) {
        super(component);
        if (updateOn == UpdateOn.VALUE_CHANGE) {
            component.addListener(value -> this.notifyListeners());
        } else {
            component.addFocusListener(new NotifyOnFocusLost());
        }
    }

    @Override
    protected T getComponentValue() {
        return ((TemporalField)this.component()).getTemporal();
    }

    @Override
    protected void setComponentValue(T value) {
        ((TemporalField)this.component()).setTemporal((Temporal)value);
    }

    private final class NotifyOnFocusLost
    extends FocusAdapter {
        private NotifyOnFocusLost() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                TemporalFieldValue.this.notifyListeners();
            }
        }
    }
}

