/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.TransferFocusOnEnter;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.calendar.CalendarPanel;
import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.text.UpdateOn;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.time.temporal.Temporal;
import java.util.Objects;
import java.util.Optional;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public final class TemporalFieldPanel<T extends Temporal>
extends JPanel {
    private final TemporalField<T> temporalField;
    private final JButton calendarButton;

    TemporalFieldPanel(DefaultBuilder<T> builder) {
        super(new BorderLayout());
        this.temporalField = Objects.requireNonNull(builder.createTemporalField());
        this.add(this.temporalField, "Center");
        Control calendarControl = this.temporalField.calendarControl().orElseThrow(() -> new IllegalArgumentException("TemporalField does not support a calendar for: " + this.temporalField.temporalClass()));
        this.calendarButton = new JButton(calendarControl);
        this.calendarButton.setPreferredSize(new Dimension(this.temporalField.getPreferredSize().height, this.temporalField.getPreferredSize().height));
        this.calendarButton.setFocusable(builder.buttonFocusable);
        this.add((Component)this.calendarButton, "East");
        this.addFocusListener(new InputFocusAdapter(this.temporalField));
    }

    public TemporalField<T> temporalField() {
        return this.temporalField;
    }

    public JButton calendarButton() {
        return this.calendarButton;
    }

    public Optional<T> optional() {
        return this.temporalField.optional();
    }

    public T getTemporal() {
        return this.temporalField.getTemporal();
    }

    public void setTemporal(Temporal temporal) {
        this.temporalField.setTemporal(temporal);
    }

    public void setTransferFocusOnEnter(boolean transferFocusOnEnter) {
        if (transferFocusOnEnter) {
            TransferFocusOnEnter.enable(this.temporalField);
            if (this.calendarButton != null) {
                TransferFocusOnEnter.enable(this.calendarButton);
            }
        } else {
            TransferFocusOnEnter.disable(this.temporalField);
            if (this.calendarButton != null) {
                TransferFocusOnEnter.disable(this.calendarButton);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.temporalField.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String text) {
        this.temporalField.setToolTipText(text);
    }

    public static <T extends Temporal> boolean supports(Class<T> temporalClass) {
        return CalendarPanel.supportedTypes().contains(Objects.requireNonNull(temporalClass));
    }

    public static <T extends Temporal> Builder<T> builder(Class<T> valueClass, String dateTimePattern) {
        return new DefaultBuilder<T>(valueClass, dateTimePattern, null);
    }

    public static <T extends Temporal> Builder<T> builder(Class<T> valueClass, String dateTimePattern, Value<T> linkedValue) {
        return new DefaultBuilder<T>(valueClass, dateTimePattern, Objects.requireNonNull(linkedValue));
    }

    private static final class DefaultBuilder<T extends Temporal>
    extends AbstractComponentBuilder<T, TemporalFieldPanel<T>, Builder<T>>
    implements Builder<T> {
        private final TemporalField.Builder<T> temporalFieldBuilder;
        private boolean buttonFocusable;

        private DefaultBuilder(Class<T> valueClass, String dateTimePattern, Value<T> linkedValue) {
            super(linkedValue);
            if (!TemporalFieldPanel.supports(valueClass)) {
                throw new IllegalArgumentException("Unsupported temporal type: " + valueClass);
            }
            this.temporalFieldBuilder = TemporalField.builder(valueClass, Objects.requireNonNull(dateTimePattern));
        }

        @Override
        public Builder<T> selectAllOnFocusGained(boolean selectAllOnFocusGained) {
            this.temporalFieldBuilder.selectAllOnFocusGained(selectAllOnFocusGained);
            return this;
        }

        @Override
        public Builder<T> columns(int columns) {
            this.temporalFieldBuilder.columns(columns);
            return this;
        }

        @Override
        public Builder<T> updateOn(UpdateOn updateOn) {
            this.temporalFieldBuilder.updateOn(updateOn);
            return this;
        }

        @Override
        public Builder<T> buttonFocusable(boolean buttonFocusable) {
            this.buttonFocusable = buttonFocusable;
            return this;
        }

        @Override
        public Builder<T> calendarIcon(ImageIcon calendarIcon) {
            this.temporalFieldBuilder.calendarIcon(calendarIcon);
            return this;
        }

        @Override
        protected TemporalFieldPanel<T> createComponent() {
            return new TemporalFieldPanel(this);
        }

        @Override
        protected ComponentValue<T, TemporalFieldPanel<T>> createComponentValue(TemporalFieldPanel<T> component) {
            return new TemporalFieldPanelValue<T>(component);
        }

        @Override
        protected void enableTransferFocusOnEnter(TemporalFieldPanel<T> component) {
            component.setTransferFocusOnEnter(true);
        }

        @Override
        protected void setInitialValue(TemporalFieldPanel<T> component, T initialValue) {
            component.setTemporal((Temporal)initialValue);
        }

        private TemporalField<T> createTemporalField() {
            return (TemporalField)((TemporalField.Builder)this.temporalFieldBuilder.clear()).build();
        }
    }

    private static final class InputFocusAdapter
    extends FocusAdapter {
        private final JFormattedTextField inputField;

        private InputFocusAdapter(JFormattedTextField inputField) {
            this.inputField = inputField;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.inputField.requestFocusInWindow();
        }
    }

    private static final class TemporalFieldPanelValue<T extends Temporal>
    extends AbstractComponentValue<T, TemporalFieldPanel<T>> {
        private TemporalFieldPanelValue(TemporalFieldPanel<T> inputPanel) {
            super(inputPanel);
            inputPanel.temporalField().addListener(temporal -> this.notifyListeners());
        }

        @Override
        protected T getComponentValue() {
            return ((TemporalFieldPanel)this.component()).getTemporal();
        }

        @Override
        protected void setComponentValue(T value) {
            ((TemporalFieldPanel)this.component()).setTemporal((Temporal)value);
        }
    }

    public static interface Builder<T extends Temporal>
    extends ComponentBuilder<T, TemporalFieldPanel<T>, Builder<T>> {
        public Builder<T> selectAllOnFocusGained(boolean var1);

        public Builder<T> columns(int var1);

        public Builder<T> updateOn(UpdateOn var1);

        public Builder<T> buttonFocusable(boolean var1);

        public Builder<T> calendarIcon(ImageIcon var1);
    }
}

