/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.combobox;

import is.codion.common.item.Item;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.combobox.FilteredComboBoxModel;
import is.codion.swing.common.model.component.combobox.ItemComboBoxModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.combobox.ComboBoxMouseWheelListener;
import is.codion.swing.common.ui.component.combobox.Completion;
import is.codion.swing.common.ui.component.combobox.CopyEditorActionsListener;
import is.codion.swing.common.ui.component.combobox.FocusableComboBox;
import is.codion.swing.common.ui.component.combobox.ItemComboBoxBuilder;
import is.codion.swing.common.ui.component.combobox.SelectedItemValue;
import is.codion.swing.common.ui.component.combobox.SteppedComboBoxUI;
import is.codion.swing.common.ui.component.text.TextComponents;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;

final class DefaultItemComboBoxBuilder<T>
extends AbstractComponentBuilder<T, JComboBox<Item<T>>, ItemComboBoxBuilder<T>>
implements ItemComboBoxBuilder<T> {
    private final List<Item<T>> items;
    private final List<ItemListener> itemListeners = new ArrayList<ItemListener>();
    private ItemComboBoxModel<T> comboBoxModel;
    private Comparator<Item<T>> comparator;
    private boolean sorted = true;
    private boolean nullable;
    private Completion.Mode completionMode = (Completion.Mode)((Object)Completion.COMBO_BOX_COMPLETION_MODE.get());
    private boolean mouseWheelScrolling = true;
    private boolean mouseWheelScrollingWithWrapAround = false;
    private int maximumRowCount = -1;
    private int popupWidth = 0;
    private ListCellRenderer<Item<T>> renderer;
    private ComboBoxEditor editor;

    DefaultItemComboBoxBuilder(List<Item<T>> items, Value<T> linkedValue) {
        super(linkedValue);
        this.items = Objects.requireNonNull(items);
        this.preferredHeight(TextComponents.preferredTextFieldHeight());
    }

    DefaultItemComboBoxBuilder(ItemComboBoxModel<T> comboBoxModel, Value<T> linkedValue) {
        super(linkedValue);
        this.comboBoxModel = Objects.requireNonNull(comboBoxModel);
        this.items = Collections.emptyList();
        this.preferredHeight(TextComponents.preferredTextFieldHeight());
    }

    @Override
    public ItemComboBoxBuilder<T> nullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> sorted(boolean sorted) {
        if (this.comboBoxModel != null) {
            throw new IllegalStateException("ComboBoxModel has been set, which controls the sorting");
        }
        this.sorted = sorted;
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> comparator(Comparator<Item<T>> comparator) {
        if (this.comboBoxModel != null) {
            throw new IllegalStateException("ComboBoxModel has been set, which controls the sorting comparator");
        }
        this.comparator = comparator;
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> completionMode(Completion.Mode completionMode) {
        this.completionMode = Objects.requireNonNull(completionMode);
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> mouseWheelScrolling(boolean mouseWheelScrolling) {
        this.mouseWheelScrolling = mouseWheelScrolling;
        if (mouseWheelScrolling) {
            this.mouseWheelScrollingWithWrapAround = false;
        }
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> mouseWheelScrollingWithWrapAround(boolean mouseWheelScrollingWithWrapAround) {
        this.mouseWheelScrollingWithWrapAround = mouseWheelScrollingWithWrapAround;
        if (mouseWheelScrollingWithWrapAround) {
            this.mouseWheelScrolling = false;
        }
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> maximumRowCount(int maximumRowCount) {
        this.maximumRowCount = maximumRowCount;
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> popupWidth(int popupWidth) {
        this.popupWidth = popupWidth;
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> renderer(ListCellRenderer<Item<T>> renderer) {
        this.renderer = Objects.requireNonNull(renderer);
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> editor(ComboBoxEditor editor) {
        this.editor = Objects.requireNonNull(editor);
        return this;
    }

    @Override
    public ItemComboBoxBuilder<T> itemListener(ItemListener itemListener) {
        this.itemListeners.add(Objects.requireNonNull(itemListener));
        return this;
    }

    @Override
    protected JComboBox<Item<T>> createComponent() {
        ItemComboBoxModel<T> itemComboBoxModel = this.initializeItemComboBoxModel();
        FocusableComboBox<Item<T>> comboBox = new FocusableComboBox<Item<T>>(itemComboBoxModel);
        Completion.enable(comboBox, this.completionMode);
        if (this.renderer != null) {
            comboBox.setRenderer(this.renderer);
        }
        if (this.editor != null) {
            comboBox.setEditor(this.editor);
        }
        if (this.mouseWheelScrolling) {
            comboBox.addMouseWheelListener(new ComboBoxMouseWheelListener((ComboBoxModel<?>)itemComboBoxModel, false));
        }
        if (this.mouseWheelScrollingWithWrapAround) {
            comboBox.addMouseWheelListener(new ComboBoxMouseWheelListener((ComboBoxModel<?>)this.comboBoxModel, true));
        }
        if (this.maximumRowCount >= 0) {
            comboBox.setMaximumRowCount(this.maximumRowCount);
        }
        this.itemListeners.forEach(comboBox::addItemListener);
        if (Utilities.systemOrCrossPlatformLookAndFeelEnabled()) {
            new SteppedComboBoxUI(comboBox, this.popupWidth);
        }
        comboBox.addPropertyChangeListener("editor", new CopyEditorActionsListener());
        return comboBox;
    }

    @Override
    protected ComponentValue<T, JComboBox<Item<T>>> createComponentValue(JComboBox<Item<T>> component) {
        return new SelectedItemValue(component);
    }

    @Override
    protected void setInitialValue(JComboBox<Item<T>> component, T initialValue) {
        component.setSelectedItem(initialValue);
    }

    private ItemComboBoxModel<T> initializeItemComboBoxModel() {
        Item nullItem = Item.item(null, (String)((String)FilteredComboBoxModel.COMBO_BOX_NULL_CAPTION.get()));
        if (this.comboBoxModel == null) {
            ArrayList<Item<T>> modelItems = new ArrayList<Item<T>>(this.items);
            if (this.nullable && !modelItems.contains(nullItem)) {
                modelItems.add(0, nullItem);
            }
            this.comboBoxModel = this.comparator != null ? ItemComboBoxModel.sortedItemComboBoxModel(modelItems, this.comparator) : (this.sorted ? ItemComboBoxModel.sortedItemComboBoxModel(modelItems) : ItemComboBoxModel.itemComboBoxModel(modelItems));
        }
        if (this.nullable && this.comboBoxModel.containsItem((Object)nullItem)) {
            this.comboBoxModel.setSelectedItem(null);
        }
        return this.comboBoxModel;
    }
}

